/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoAnnotation;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationExpression;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.shaded.auto.common.MoreTypes;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;

class AnnotationCreatorGenerator
extends SourceFileGenerator<TypeElement> {
    private static final SimpleTypeVisitor6<Void, Set<TypeElement>> TRAVERSE_NESTED_ANNOTATIONS = new SimpleTypeVisitor6<Void, Set<TypeElement>>(){

        @Override
        public Void visitDeclared(DeclaredType t, Set<TypeElement> p) {
            TypeElement typeElement = MoreTypes.asTypeElement(t);
            if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                AnnotationCreatorGenerator.nestedAnnotationElements(typeElement, p);
            }
            return null;
        }
    };

    @Inject
    AnnotationCreatorGenerator(Filer filer, Elements elements, SourceVersion sourceVersion) {
        super(filer, elements, sourceVersion);
    }

    @Override
    ClassName nameGeneratedType(TypeElement annotationType) {
        return AnnotationExpression.getAnnotationCreatorClassName(annotationType);
    }

    @Override
    Element originatingElement(TypeElement annotationType) {
        return annotationType;
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, TypeElement annotationType) {
        TypeSpec.Builder annotationCreatorBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (TypeElement annotationElement : this.annotationsToCreate(annotationType)) {
            annotationCreatorBuilder.addMethod(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return Optional.of(annotationCreatorBuilder);
    }

    private MethodSpec buildCreateMethod(ClassName generatedTypeName, TypeElement annotationElement) {
        String createMethodName = AnnotationExpression.createMethodName(annotationElement);
        MethodSpec.Builder createMethod = MethodSpec.methodBuilder((String)createMethodName).addAnnotation(AutoAnnotation.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get((TypeMirror)annotationElement.asType()));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (ExecutableElement annotationMember : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
            String parameterName = annotationMember.getSimpleName().toString();
            TypeName parameterType = TypeName.get((TypeMirror)annotationMember.getReturnType());
            createMethod.addParameter(parameterType, parameterName, new Modifier[0]);
            parameters.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}));
        }
        ClassName autoAnnotationClass = generatedTypeName.peerClass("AutoAnnotation_" + generatedTypeName.simpleName() + "_" + createMethodName);
        createMethod.addStatement("return new $T($L)", new Object[]{autoAnnotationClass, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameters.build())});
        return createMethod.build();
    }

    protected Set<TypeElement> annotationsToCreate(TypeElement annotationElement) {
        return AnnotationCreatorGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<TypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<TypeElement> nestedAnnotationElements(TypeElement annotationElement, Set<TypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (ExecutableElement method : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
                TRAVERSE_NESTED_ANNOTATIONS.visit(method.getReturnType(), annotationElements);
            }
        }
        return annotationElements;
    }
}

