/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import javax.lang.model.type.TypeMirror;

class BindingMethodImplementation {
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final BindingExpression bindingExpression;
    private final ClassName componentName;
    private final DaggerTypes types;

    BindingMethodImplementation(ResolvedBindings resolvedBindings, BindingRequest request, BindingExpression bindingExpression, ClassName componentName, DaggerTypes types) {
        this.binding = resolvedBindings.contributionBinding();
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.bindingExpression = (BindingExpression)Preconditions.checkNotNull((Object)bindingExpression);
        this.componentName = (ClassName)Preconditions.checkNotNull((Object)componentName);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
    }

    CodeBlock body() {
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.simpleBindingExpression()});
    }

    protected final CodeBlock simpleBindingExpression() {
        return this.bindingExpression.getDependencyExpression(this.componentName).codeBlock();
    }

    final TypeMirror returnType() {
        if (this.request.isRequestKind(RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent()) {
            return this.binding.contributedPrimitiveType().get();
        }
        return this.types.accessibleType(this.requestedType(), this.componentName);
    }

    private TypeMirror requestedType() {
        if (this.request.requestKind().isPresent()) {
            return RequestKinds.requestType(this.request.requestKind().get(), this.binding.contributedType(), this.types);
        }
        return this.types.wrapType(this.binding.contributedType(), this.request.frameworkType().get().frameworkClass());
    }
}

