/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.TypeNames;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class CodeBlocks {
    static Collector<CodeBlock, ?, CodeBlock> toParametersCodeBlock() {
        return CodeBlock.joining((String)", ");
    }

    static Collector<CodeBlock, ?, CodeBlock> toConcatenatedCodeBlock() {
        return CodeBlock.joining((String)"\n", (String)"", (String)"\n");
    }

    static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toParametersCodeBlock());
    }

    static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toConcatenatedCodeBlock());
    }

    static void addAnnotation(MethodSpec.Builder method, DeclaredType nullableType) {
        method.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(nullableType)));
    }

    static CodeBlock anonymousProvider(TypeName providedType, CodeBlock body) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.providerOf(providedType)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(providedType).addCode(body).build()).build()});
    }

    static CodeBlock cast(CodeBlock expression, Class<?> castTo) {
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{castTo, expression});
    }

    static CodeBlock type(TypeMirror type) {
        return CodeBlock.of((String)"$T", (Object[])new Object[]{type});
    }

    static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{toWrap});
    }

    static CodeBlock javadocLinkTo(ExecutableElement executableElement) {
        CodeBlock.Builder builder = CodeBlock.builder().add("{@link $T#", new Object[]{TypeNames.rawTypeName((TypeName)ClassName.get((TypeElement)MoreElements.asType(executableElement.getEnclosingElement())))});
        switch (executableElement.getKind()) {
            case METHOD: {
                builder.add("$L", new Object[]{executableElement.getSimpleName()});
                break;
            }
            case CONSTRUCTOR: {
                builder.add("$L", new Object[]{executableElement.getEnclosingElement().getSimpleName()});
                break;
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                throw new IllegalArgumentException("cannot create a javadoc link to an initializer: " + executableElement);
            }
            default: {
                throw new AssertionError((Object)executableElement.toString());
            }
        }
        builder.add("(", new Object[0]);
        builder.add(executableElement.getParameters().stream().map(parameter -> CodeBlock.of((String)"$T", (Object[])new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)parameter.asType()))})).collect(CodeBlocks.toParametersCodeBlock()));
        return builder.add(")}", new Object[0]).build();
    }

    private CodeBlocks() {
    }
}

