/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerGraphs;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

final class DiagnosticReporterFactory {
    private final DaggerTypes types;
    private final Messager messager;
    private final DependencyRequestFormatter dependencyRequestFormatter;

    @Inject
    DiagnosticReporterFactory(DaggerTypes types, Messager messager, DependencyRequestFormatter dependencyRequestFormatter) {
        this.types = types;
        this.messager = messager;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
    }

    DiagnosticReporterImpl reporter(BindingGraph graph, BindingGraphPlugin plugin) {
        return new DiagnosticReporterImpl(graph, plugin.pluginName());
    }

    private static <K, V> java.util.function.Function<K, V> memoize(java.util.function.Function<K, V> uncached) {
        Function uncachedAsBaseFunction = uncached::apply;
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)uncachedAsBaseFunction));
        java.util.function.Function<Object, Object> memoized = arg_0 -> ((LoadingCache)cache).apply(arg_0);
        return memoized;
    }

    static /* synthetic */ java.util.function.Function access$000(java.util.function.Function x0) {
        return DiagnosticReporterFactory.memoize(x0);
    }

    final class DiagnosticReporterImpl
    implements DiagnosticReporter {
        private final java.util.function.Function<TypeElement, Iterable<TypeElement>> supertypes = DiagnosticReporterFactory.access$000(component -> Iterables.transform(DiagnosticReporterFactory.this.types.supertypes(component.asType()), type -> MoreTypes.asTypeElement(type)));
        private final Table<BindingGraph.MaybeBindingNode, BindingGraph.DependencyEdge, ImmutableList<BindingGraph.Node>> shortestPaths = HashBasedTable.create();
        private final BindingGraph graph;
        private final String plugin;
        private final TypeElement rootComponent;
        private final ImmutableSet.Builder<Diagnostic.Kind> reportedDiagnosticKinds = ImmutableSet.builder();

        DiagnosticReporterImpl(BindingGraph graph, String plugin) {
            this.graph = graph;
            this.plugin = plugin;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent();
        }

        ImmutableSet<Diagnostic.Kind> reportedDiagnosticKinds() {
            return this.reportedDiagnosticKinds.build();
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat) {
            StringBuilder message = new StringBuilder(messageFormat);
            this.appendComponentPathUnlessAtRoot(message, (BindingGraph.Node)componentNode);
            this.printMessage(diagnosticKind, message, this.rootComponent);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportComponent(diagnosticKind, componentNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBindingNode bindingNode, String message) {
            this.printMessage(diagnosticKind, message + new DiagnosticInfo(bindingNode), this.rootComponent);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBindingNode bindingNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportBinding(diagnosticKind, bindingNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.printMessage(diagnosticKind, message + new DiagnosticInfo(dependencyEdge), this.rootComponent);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportDependency(diagnosticKind, dependencyEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.printMessage(diagnosticKind, message, childFactoryMethodEdge.factoryMethod());
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        private String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
            return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
        }

        private BindingGraph.Node source(BindingGraph.Edge edge) {
            return (BindingGraph.Node)this.graph.network().incidentNodes((Object)edge).source();
        }

        void printMessage(Diagnostic.Kind diagnosticKind, CharSequence message, Element elementToReport) {
            this.reportedDiagnosticKinds.add((Object)diagnosticKind);
            StringBuilder fullMessage = new StringBuilder();
            this.appendBracketPrefix(fullMessage, this.plugin);
            if (!DaggerElements.elementEncloses(this.rootComponent, elementToReport)) {
                this.appendBracketPrefix(fullMessage, DaggerElements.elementToString(elementToReport));
                elementToReport = this.rootComponent;
            }
            DiagnosticReporterFactory.this.messager.printMessage(diagnosticKind, fullMessage.append(message), elementToReport);
        }

        private void appendComponentPathUnlessAtRoot(StringBuilder message, BindingGraph.Node node) {
            if (!node.componentPath().equals(this.graph.rootComponentNode().componentPath())) {
                new Formatter(message).format(" [%s]", node.componentPath());
            }
        }

        private void appendBracketPrefix(StringBuilder message, String prefix) {
            new Formatter(message).format("[%s] ", prefix);
        }

        private final class DiagnosticInfo {
            final ImmutableList<BindingGraph.DependencyEdge> dependencyTrace;
            final ImmutableSet<BindingGraph.DependencyEdge> requests;
            final ImmutableSet<BindingGraph.DependencyEdge> entryPoints;

            DiagnosticInfo(BindingGraph.MaybeBindingNode bindingNode) {
                this.entryPoints = DiagnosticReporterImpl.this.graph.entryPointEdgesDependingOnBindingNode(bindingNode);
                this.requests = this.requests(bindingNode);
                this.dependencyTrace = this.dependencyTrace(bindingNode, this.entryPoints);
            }

            DiagnosticInfo(BindingGraph.DependencyEdge dependencyEdge) {
                this.requests = ImmutableSet.of((Object)dependencyEdge);
                ImmutableList.Builder dependencyTraceBuilder = ImmutableList.builder();
                dependencyTraceBuilder.add((Object)dependencyEdge);
                if (dependencyEdge.isEntryPoint()) {
                    this.entryPoints = ImmutableSet.of((Object)dependencyEdge);
                } else {
                    BindingGraph.BindingNode bindingNode = (BindingGraph.BindingNode)DiagnosticReporterImpl.this.source((BindingGraph.Edge)dependencyEdge);
                    this.entryPoints = DiagnosticReporterImpl.this.graph.entryPointEdgesDependingOnBindingNode((BindingGraph.MaybeBindingNode)bindingNode);
                    dependencyTraceBuilder.addAll(this.dependencyTrace((BindingGraph.MaybeBindingNode)bindingNode, this.entryPoints));
                }
                this.dependencyTrace = dependencyTraceBuilder.build();
            }

            public String toString() {
                StringBuilder message = new StringBuilder(this.dependencyTrace.size() * 100);
                this.dependencyTrace.forEach(edge -> DiagnosticReporterFactory.this.dependencyRequestFormatter.appendFormatLine(message, edge.dependencyRequest()));
                DiagnosticReporterImpl.this.appendComponentPathUnlessAtRoot(message, DiagnosticReporterImpl.this.source((BindingGraph.Edge)Iterables.getLast(this.dependencyTrace)));
                ImmutableSet otherRequests = this.requests.stream().filter(request -> !request.isEntryPoint()).filter(request -> !request.equals(this.dependencyTrace.get(0))).map(request -> (Element)request.dependencyRequest().requestElement().get()).collect(DaggerStreams.toImmutableSet());
                if (!otherRequests.isEmpty()) {
                    message.append("\nIt is also requested at:");
                    for (Element otherRequest : otherRequests) {
                        message.append("\n    ").append(DaggerElements.elementToString(otherRequest));
                    }
                }
                if (this.entryPoints.size() > 1) {
                    message.append("\nThe following other entry points also depend on it:");
                    this.entryPoints.stream().filter(entryPoint -> !entryPoint.equals(Iterables.getLast(this.dependencyTrace))).sorted(this.rootComponentFirst().thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder())).forEachOrdered(entryPoint -> {
                        message.append("\n    ");
                        Element requestElement = (Element)entryPoint.dependencyRequest().requestElement().get();
                        message.append(DaggerElements.elementToString(requestElement));
                        ComponentPath componentPath = DiagnosticReporterImpl.this.source((BindingGraph.Edge)entryPoint).componentPath();
                        if (!componentPath.atRoot() || !requestElement.getEnclosingElement().equals(DiagnosticReporterImpl.this.rootComponent)) {
                            message.append(String.format(" [%s]", componentPath));
                        }
                    });
                }
                return message.toString();
            }

            ImmutableList<BindingGraph.DependencyEdge> dependencyTrace(BindingGraph.MaybeBindingNode bindingNode, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
                BindingGraph.DependencyEdge entryPointForTrace = Collections.min(entryPoints, this.rootComponentFirst().thenComparing(this.shortestDependencyPathFirst(bindingNode)).thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder()));
                ImmutableList<BindingGraph.Node> shortestBindingPath = this.shortestPathFromEntryPoint(entryPointForTrace, bindingNode);
                Verify.verify((!shortestBindingPath.isEmpty() ? 1 : 0) != 0, (String)"no dependency path from %s to %s in %s", (Object)entryPointForTrace, (Object)bindingNode, (Object)DiagnosticReporterImpl.this.graph);
                ImmutableList.Builder dependencyTrace = ImmutableList.builder();
                dependencyTrace.add((Object)entryPointForTrace);
                for (int i = 0; i < shortestBindingPath.size() - 1; ++i) {
                    Set dependenciesBetween = DiagnosticReporterImpl.this.graph.network().edgesConnecting((Object)((BindingGraph.Node)shortestBindingPath.get(i)), (Object)((BindingGraph.Node)shortestBindingPath.get(i + 1)));
                    dependencyTrace.add((Object)((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)));
                }
                return dependencyTrace.build().reverse();
            }

            ImmutableSet<BindingGraph.DependencyEdge> requests(BindingGraph.MaybeBindingNode bindingNode) {
                return DiagnosticReporterImpl.this.graph.network().inEdges((Object)bindingNode).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> edge.dependencyRequest().requestElement().isPresent()).sorted(this.requestEnclosingTypeName().thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableSet());
            }

            Comparator<BindingGraph.DependencyEdge> rootComponentFirst() {
                return Comparator.comparingInt(entryPoint -> DiagnosticReporterImpl.this.source((BindingGraph.Edge)entryPoint).componentPath().components().size());
            }

            Comparator<BindingGraph.DependencyEdge> shortestDependencyPathFirst(BindingGraph.MaybeBindingNode bindingNode) {
                return Comparator.comparing(entryPoint -> this.shortestPathFromEntryPoint((BindingGraph.DependencyEdge)entryPoint, bindingNode).size());
            }

            ImmutableList<BindingGraph.Node> shortestPathFromEntryPoint(BindingGraph.DependencyEdge entryPoint, BindingGraph.MaybeBindingNode bindingNode) {
                return DiagnosticReporterImpl.this.shortestPaths.row((Object)bindingNode).computeIfAbsent(entryPoint, ep -> DaggerGraphs.shortestPath(node -> Sets.filter((Set)DiagnosticReporterImpl.this.graph.network().successors(node), BindingGraph.MaybeBindingNode.class::isInstance), (BindingGraph.Node)DiagnosticReporterImpl.this.graph.network().incidentNodes(ep).target(), bindingNode));
            }

            Comparator<BindingGraph.DependencyEdge> nearestComponentSupertypeFirst() {
                return Comparator.comparingInt(entryPoint -> Iterables.indexOf((Iterable)((Iterable)DiagnosticReporterImpl.this.supertypes.apply(this.componentContainingEntryPoint((BindingGraph.DependencyEdge)entryPoint))), (Predicate)Predicates.equalTo((Object)this.typeDeclaringEntryPoint((BindingGraph.DependencyEdge)entryPoint))));
            }

            TypeElement componentContainingEntryPoint(BindingGraph.DependencyEdge entryPoint) {
                return DiagnosticReporterImpl.this.source((BindingGraph.Edge)entryPoint).componentPath().currentComponent();
            }

            TypeElement typeDeclaringEntryPoint(BindingGraph.DependencyEdge entryPoint) {
                return MoreElements.asType(((Element)entryPoint.dependencyRequest().requestElement().get()).getEnclosingElement());
            }

            Comparator<BindingGraph.DependencyEdge> requestEnclosingTypeName() {
                return Comparator.comparing(edge -> DaggerElements.closestEnclosingTypeElement((Element)edge.dependencyRequest().requestElement().get()).getQualifiedName().toString());
            }

            Comparator<BindingGraph.DependencyEdge> requestElementDeclarationOrder() {
                return Comparator.comparing(edge -> (Element)edge.dependencyRequest().requestElement().get(), DaggerElements.DECLARATION_ORDER);
            }
        }
    }
}

