/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.GeneratedInstanceBindingExpression;
import dagger.internal.codegen.MissingBindingExpression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.ModifiableConcreteMethodBindingExpression;
import dagger.internal.codegen.PrunedConcreteMethodBindingExpression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.BindingKind;
import java.util.Optional;
import javax.lang.model.element.Modifier;

final class ModifiableBindingExpressions {
    private final Optional<ModifiableBindingExpressions> parent;
    private final ComponentBindingExpressions bindingExpressions;
    private final BindingGraph graph;
    private final GeneratedComponentModel generatedComponentModel;
    private final CompilerOptions compilerOptions;

    ModifiableBindingExpressions(Optional<ModifiableBindingExpressions> parent, ComponentBindingExpressions bindingExpressions, BindingGraph graph, GeneratedComponentModel generatedComponentModel, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.bindingExpressions = bindingExpressions;
        this.graph = graph;
        this.generatedComponentModel = generatedComponentModel;
        this.compilerOptions = compilerOptions;
    }

    ModifiableBindingType registerComponentMethodIfModifiable(ComponentDescriptor.ComponentMethodDescriptor componentMethod, MethodSpec method) {
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        ModifiableBindingType modifiableBindingType = this.getModifiableBindingType(request);
        if (modifiableBindingType.isModifiable()) {
            this.generatedComponentModel.registerModifiableBindingMethod(modifiableBindingType, request, method, this.newModifiableBindingWillBeFinalized(modifiableBindingType, request));
        }
        return modifiableBindingType;
    }

    Optional<ModifiableBindingMethods.ModifiableBindingMethod> getModifiableBindingMethod(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod) {
        if (this.shouldModifyKnownBinding(modifiableBindingMethod)) {
            MethodSpec baseMethod = modifiableBindingMethod.methodSpec();
            return Optional.of(ModifiableBindingMethods.ModifiableBindingMethod.implement(modifiableBindingMethod, MethodSpec.methodBuilder((String)baseMethod.name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(baseMethod.returnType).addAnnotation(Override.class).addCode(this.bindingExpressions.getBindingExpression(modifiableBindingMethod.request()).getModifiableBindingMethodImplementation(modifiableBindingMethod, this.generatedComponentModel)).build(), this.knownModifiableBindingWillBeFinalized(modifiableBindingMethod)));
        }
        return Optional.empty();
    }

    private boolean knownModifiableBindingWillBeFinalized(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod) {
        ModifiableBindingType newModifiableBindingType = this.getModifiableBindingType(modifiableBindingMethod.request());
        if (!newModifiableBindingType.isModifiable()) {
            return true;
        }
        return this.modifiableBindingWillBeFinalized(newModifiableBindingType, this.shouldModifyBinding(newModifiableBindingType, modifiableBindingMethod.request()));
    }

    private boolean newModifiableBindingWillBeFinalized(ModifiableBindingType modifiableBindingType, BindingRequest request) {
        return this.modifiableBindingWillBeFinalized(modifiableBindingType, this.shouldModifyBinding(modifiableBindingType, request));
    }

    private boolean modifiableBindingWillBeFinalized(ModifiableBindingType modifiableBindingType, boolean modifyingBinding) {
        switch (modifiableBindingType) {
            case MISSING: 
            case GENERATED_INSTANCE: 
            case OPTIONAL: 
            case INJECTION: {
                return modifyingBinding;
            }
            case MULTIBINDING: 
            case MODULE_INSTANCE: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Building binding expression for unsupported ModifiableBindingType [%s].", new Object[]{modifiableBindingType}));
    }

    Optional<BindingExpression> maybeCreateModifiableBindingExpression(BindingRequest request) {
        ModifiableBindingType type = this.getModifiableBindingType(request);
        if (!type.isModifiable()) {
            return Optional.empty();
        }
        return Optional.of(this.createModifiableBindingExpression(type, request));
    }

    private BindingExpression createModifiableBindingExpression(ModifiableBindingType type, BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod = this.generatedComponentModel.getModifiableBindingMethod(request);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().findMatchingComponentMethod(request);
        switch (type) {
            case GENERATED_INSTANCE: {
                if (this.generatedComponentModel.isAbstract()) {
                    return new GeneratedInstanceBindingExpression(this.generatedComponentModel, resolvedBindings, request, matchingModifiableBindingMethod, matchingComponentMethod);
                }
                return this.bindingExpressions.wrapInMethod(resolvedBindings, request, this.bindingExpressions.createBindingExpression(resolvedBindings, request));
            }
            case MISSING: {
                if (this.generatedComponentModel.isAbstract()) {
                    return new MissingBindingExpression(this.generatedComponentModel, request, matchingModifiableBindingMethod, matchingComponentMethod);
                }
                return new PrunedConcreteMethodBindingExpression();
            }
            case OPTIONAL: 
            case INJECTION: 
            case MULTIBINDING: 
            case MODULE_INSTANCE: {
                return this.bindingExpressions.wrapInMethod(resolvedBindings, request, this.bindingExpressions.createBindingExpression(resolvedBindings, request));
            }
        }
        throw new IllegalStateException(String.format("Building binding expression for unsupported ModifiableBindingType [%s].", new Object[]{type}));
    }

    private ModifiableBindingType getModifiableBindingType(BindingRequest request) {
        if (!this.compilerOptions.aheadOfTimeSubcomponents()) {
            return ModifiableBindingType.NONE;
        }
        if (this.generatedComponentModel.componentDescriptor().kind().isTopLevel()) {
            return ModifiableBindingType.NONE;
        }
        if (this.resolvedInThisComponent(request)) {
            ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
            if (resolvedBindings.contributionBindings().isEmpty()) {
                return ModifiableBindingType.NONE;
            }
            ContributionBinding binding = resolvedBindings.contributionBinding();
            if (binding.requiresGeneratedInstance()) {
                return ModifiableBindingType.GENERATED_INSTANCE;
            }
            if (binding.kind().equals((Object)BindingKind.OPTIONAL)) {
                return ModifiableBindingType.OPTIONAL;
            }
            if (resolvedBindings.bindingType().equals((Object)BindingType.PROVISION) && binding.isSyntheticMultibinding()) {
                return ModifiableBindingType.MULTIBINDING;
            }
            if (binding.kind().equals((Object)BindingKind.INJECTION)) {
                return ModifiableBindingType.INJECTION;
            }
            if (binding.requiresModuleInstance()) {
                return ModifiableBindingType.MODULE_INSTANCE;
            }
        } else if (!this.resolvableBinding(request)) {
            return ModifiableBindingType.MISSING;
        }
        return ModifiableBindingType.NONE;
    }

    private boolean shouldModifyKnownBinding(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod) {
        ModifiableBindingType newModifiableBindingType = this.getModifiableBindingType(modifiableBindingMethod.request());
        if (!newModifiableBindingType.equals((Object)modifiableBindingMethod.type())) {
            return true;
        }
        return this.shouldModifyBinding(modifiableBindingMethod.type(), modifiableBindingMethod.request());
    }

    private boolean shouldModifyBinding(ModifiableBindingType modifiableBindingType, BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        switch (modifiableBindingType) {
            case GENERATED_INSTANCE: {
                return !this.generatedComponentModel.isAbstract();
            }
            case MISSING: {
                return this.resolvableBinding(request) || !this.generatedComponentModel.isAbstract();
            }
            case OPTIONAL: {
                return !resolvedBindings.contributionBinding().dependencies().isEmpty();
            }
            case MULTIBINDING: {
                return !this.generatedComponentModel.superclassContributionsMade(request.key()).containsAll(resolvedBindings.contributionBinding().dependencies());
            }
            case INJECTION: {
                return !resolvedBindings.contributionBinding().kind().equals((Object)BindingKind.INJECTION);
            }
            case MODULE_INSTANCE: {
                return !this.generatedComponentModel.supermodel().isPresent() || !this.generatedComponentModel.isAbstract();
            }
        }
        throw new IllegalStateException(String.format("Overriding modifiable binding method with unsupported ModifiableBindingType [%s].", new Object[]{modifiableBindingType}));
    }

    private boolean resolvableBinding(BindingRequest request) {
        ModifiableBindingExpressions expressions = this;
        while (expressions != null) {
            if (expressions.resolvedInThisComponent(request)) {
                return true;
            }
            expressions = expressions.parent.orElse(null);
        }
        return false;
    }

    private boolean resolvedInThisComponent(BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        return resolvedBindings != null && !resolvedBindings.ownedBindings().isEmpty();
    }

    Optional<BindingExpression> maybeWrapInModifiableMethodBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request, BindingMethodImplementation methodImplementation, Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod) {
        ModifiableBindingType modifiableBindingType = this.getModifiableBindingType(request);
        if (this.shouldUseAModifiableConcreteMethodBindingExpression(modifiableBindingType, matchingComponentMethod)) {
            return Optional.of(new ModifiableConcreteMethodBindingExpression(resolvedBindings, request, modifiableBindingType, methodImplementation, this.generatedComponentModel, matchingModifiableBindingMethod, this.newModifiableBindingWillBeFinalized(modifiableBindingType, request)));
        }
        return Optional.empty();
    }

    private boolean shouldUseAModifiableConcreteMethodBindingExpression(ModifiableBindingType type, Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod) {
        return type.isModifiable() && (this.generatedComponentModel.supermodel().isPresent() || !matchingComponentMethod.isPresent());
    }
}

