/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.ResolvedBindings;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ModifiableConcreteMethodBindingExpression
extends MethodBindingExpression {
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final ModifiableBindingType modifiableBindingType;
    private final BindingMethodImplementation methodImplementation;
    private final GeneratedComponentModel generatedComponentModel;
    private final boolean bindingFinalized;
    private Optional<String> methodName;

    ModifiableConcreteMethodBindingExpression(ResolvedBindings resolvedBindings, BindingRequest request, ModifiableBindingType modifiableBindingType, BindingMethodImplementation methodImplementation, GeneratedComponentModel generatedComponentModel, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod, boolean bindingFinalized) {
        super(methodImplementation, generatedComponentModel, matchingModifiableBindingMethod);
        this.binding = resolvedBindings.contributionBinding();
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.modifiableBindingType = (ModifiableBindingType)((Object)Preconditions.checkNotNull((Object)((Object)modifiableBindingType)));
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.bindingFinalized = bindingFinalized;
        this.methodName = matchingModifiableBindingMethod.map(modifiableMethod -> modifiableMethod.methodSpec().name);
    }

    @Override
    protected void addMethod() {
        if (!this.methodName.isPresent()) {
            this.methodName = Optional.of(this.generatedComponentModel.getUniqueMethodName(this.request, this.binding));
            this.generatedComponentModel.addModifiableBindingMethod(this.modifiableBindingType, this.request, MethodSpec.methodBuilder((String)this.methodName.get()).addModifiers(new Modifier[]{this.bindingFinalized ? Modifier.PRIVATE : Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)this.methodImplementation.returnType())).addCode(this.methodImplementation.body()).build(), this.bindingFinalized);
        }
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((boolean)this.methodName.isPresent(), (Object)"addMethod() must be called before methodName().");
        return this.methodName.get();
    }
}

