/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AnyBindingMethodValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

final class MultibindingAnnotationsProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final Messager messager;

    @Inject
    MultibindingAnnotationsProcessingStep(AnyBindingMethodValidator anyBindingMethodValidator, Messager messager) {
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(IntoSet.class, ElementsIntoSet.class, IntoMap.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        Multimaps.asMap(elementsByAnnotation).forEach((annotation, elements) -> {
            for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
                if (this.anyBindingMethodValidator.isBindingMethod(method)) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods", method, DaggerElements.getAnnotationMirror(method, annotation).get());
            }
        });
        return ImmutableSet.of();
    }
}

