/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.persist.LDAPPersister;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GenerateSchemaFromSource
extends CommandLineTool
implements Serializable {
    private static final long serialVersionUID = 1029934829295836935L;
    private BooleanArgument modifyFormatArg;
    private FileArgument outputFileArg;
    private StringArgument classNameArg;

    public static void main(String[] args) {
        ResultCode resultCode = GenerateSchemaFromSource.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        GenerateSchemaFromSource tool = new GenerateSchemaFromSource(outStream, errStream);
        return tool.runTool(args);
    }

    public GenerateSchemaFromSource(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "generate-schema-from-source";
    }

    @Override
    public String getToolDescription() {
        return PersistMessages.INFO_GEN_SCHEMA_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.5";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.classNameArg = new StringArgument(Character.valueOf('c'), "javaClass", true, 1, PersistMessages.INFO_GEN_SCHEMA_VALUE_PLACEHOLDER_CLASS.get(), PersistMessages.INFO_GEN_SCHEMA_ARG_DESCRIPTION_JAVA_CLASS.get());
        this.classNameArg.addLongIdentifier("java-class", true);
        parser.addArgument(this.classNameArg);
        this.outputFileArg = new FileArgument(Character.valueOf('f'), "outputFile", true, 1, PersistMessages.INFO_GEN_SCHEMA_VALUE_PLACEHOLDER_PATH.get(), PersistMessages.INFO_GEN_SCHEMA_ARG_DESCRIPTION_OUTPUT_FILE.get(), false, true, true, false);
        this.outputFileArg.addLongIdentifier("output-file", true);
        parser.addArgument(this.outputFileArg);
        this.modifyFormatArg = new BooleanArgument(Character.valueOf('m'), "modifyFormat", PersistMessages.INFO_GEN_SCHEMA_ARG_DESCRIPTION_MODIFY_FORMAT.get());
        this.modifyFormatArg.addLongIdentifier("modify-format", true);
        parser.addArgument(this.modifyFormatArg);
    }

    @Override
    public ResultCode doToolProcessing() {
        List<ObjectClassDefinition> objectClasses;
        List<AttributeTypeDefinition> attrTypes;
        LDAPPersister<?> persister;
        Class<?> targetClass;
        String className = this.classNameArg.getValue();
        try {
            targetClass = Class.forName(className);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SCHEMA_CANNOT_LOAD_CLASS.get(className));
            return ResultCode.PARAM_ERROR;
        }
        try {
            persister = LDAPPersister.getInstance(targetClass);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SCHEMA_INVALID_CLASS.get(className, StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        try {
            attrTypes = persister.constructAttributeTypes();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SCHEMA_ERROR_CONSTRUCTING_ATTRS.get(className, StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        try {
            objectClasses = persister.constructObjectClasses();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SCHEMA_ERROR_CONSTRUCTING_OCS.get(className, StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        int i = 0;
        ASN1OctetString[] attrTypeValues = new ASN1OctetString[attrTypes.size()];
        for (AttributeTypeDefinition d : attrTypes) {
            attrTypeValues[i++] = new ASN1OctetString(d.toString());
        }
        i = 0;
        ASN1OctetString[] ocValues = new ASN1OctetString[objectClasses.size()];
        for (ObjectClassDefinition d : objectClasses) {
            ocValues[i++] = new ASN1OctetString(d.toString());
        }
        LDIFRecord schemaRecord = this.modifyFormatArg.isPresent() ? new LDIFModifyChangeRecord("cn=schema", new Modification(ModificationType.ADD, "attributeTypes", attrTypeValues), new Modification(ModificationType.ADD, "objectClasses", ocValues)) : new Entry("cn=schema", new Attribute("objectClass", "top", "ldapSubentry", "subschema"), new Attribute("cn", "schema"), new Attribute("attributeTypes", attrTypeValues), new Attribute("objectClasses", ocValues));
        File outputFile = this.outputFileArg.getValue();
        try {
            LDIFWriter ldifWriter = new LDIFWriter(outputFile);
            ldifWriter.writeLDIFRecord(schemaRecord);
            ldifWriter.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SCHEMA_CANNOT_WRITE_SCHEMA.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        return ResultCode.SUCCESS;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--javaClass", "com.example.MyClass", "--outputFile", "MyClass-schema.ldif"};
        examples.put(args, PersistMessages.INFO_GEN_SCHEMA_EXAMPLE_1.get());
        return examples;
    }
}

