/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.DuplicateValueBehavior;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFAttribute;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.TrailingSpaceBehavior;
import com.unboundid.util.AggregateInputStream;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.AsynchronousParallelProcessor;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFReader
implements Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    private static final int ASYNC_MIN_PER_PARSING_THREAD = 3;
    private static final int ASYNC_QUEUE_SIZE = 500;
    private static final Entry SKIP_ENTRY = new Entry("cn=skipped");
    private static final String DEFAULT_RELATIVE_BASE_PATH;
    private final BufferedReader reader;
    private volatile DuplicateValueBehavior duplicateValueBehavior;
    private long lineNumberCounter = 0L;
    private final LDIFReaderChangeRecordTranslator changeRecordTranslator;
    private final LDIFReaderEntryTranslator entryTranslator;
    private Schema schema;
    private volatile String relativeBasePath;
    private volatile TrailingSpaceBehavior trailingSpaceBehavior;
    private final boolean isAsync;
    private final AsynchronousParallelProcessor<UnparsedLDIFRecord, LDIFRecord> asyncParser;
    private final AtomicBoolean asyncParsingComplete;
    private final BlockingQueue<Result<UnparsedLDIFRecord, LDIFRecord>> asyncParsedRecords;

    public LDIFReader(String path) throws IOException {
        this(new FileInputStream(path));
    }

    public LDIFReader(String path, int numParseThreads) throws IOException {
        this(new FileInputStream(path), numParseThreads);
    }

    public LDIFReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public LDIFReader(File file, int numParseThreads) throws IOException {
        this(new FileInputStream(file), numParseThreads);
    }

    public LDIFReader(File[] files, int numParseThreads, LDIFReaderEntryTranslator entryTranslator) throws IOException {
        this(files, numParseThreads, entryTranslator, null);
    }

    public LDIFReader(File[] files, int numParseThreads, LDIFReaderEntryTranslator entryTranslator, LDIFReaderChangeRecordTranslator changeRecordTranslator) throws IOException {
        this(files, numParseThreads, entryTranslator, changeRecordTranslator, "UTF-8");
    }

    public LDIFReader(File[] files, int numParseThreads, LDIFReaderEntryTranslator entryTranslator, LDIFReaderChangeRecordTranslator changeRecordTranslator, String characterSet) throws IOException {
        this(LDIFReader.createAggregateInputStream(files), numParseThreads, entryTranslator, changeRecordTranslator, characterSet);
    }

    private static InputStream createAggregateInputStream(File ... files) throws IOException {
        if (files.length == 0) {
            throw new IOException(LDIFMessages.ERR_READ_NO_LDIF_FILES.get());
        }
        return new AggregateInputStream(true, files);
    }

    public LDIFReader(InputStream inputStream) {
        this(inputStream, 0);
    }

    public LDIFReader(InputStream inputStream, int numParseThreads) {
        this(new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")), 131072), numParseThreads);
    }

    public LDIFReader(InputStream inputStream, int numParseThreads, LDIFReaderEntryTranslator entryTranslator) {
        this(inputStream, numParseThreads, entryTranslator, null);
    }

    public LDIFReader(InputStream inputStream, int numParseThreads, LDIFReaderEntryTranslator entryTranslator, LDIFReaderChangeRecordTranslator changeRecordTranslator) {
        this(inputStream, numParseThreads, entryTranslator, changeRecordTranslator, "UTF-8");
    }

    public LDIFReader(InputStream inputStream, int numParseThreads, LDIFReaderEntryTranslator entryTranslator, LDIFReaderChangeRecordTranslator changeRecordTranslator, String characterSet) {
        this(new BufferedReader(new InputStreamReader(inputStream, Charset.forName(characterSet)), 131072), numParseThreads, entryTranslator, changeRecordTranslator);
    }

    public LDIFReader(BufferedReader reader) {
        this(reader, 0);
    }

    public LDIFReader(BufferedReader reader, int numParseThreads) {
        this(reader, numParseThreads, null);
    }

    public LDIFReader(BufferedReader reader, int numParseThreads, LDIFReaderEntryTranslator entryTranslator) {
        this(reader, numParseThreads, entryTranslator, null);
    }

    public LDIFReader(BufferedReader reader, int numParseThreads, LDIFReaderEntryTranslator entryTranslator, LDIFReaderChangeRecordTranslator changeRecordTranslator) {
        Validator.ensureNotNull(reader);
        Validator.ensureTrue(numParseThreads >= 0, "LDIFReader.numParseThreads must not be negative.");
        this.reader = reader;
        this.entryTranslator = entryTranslator;
        this.changeRecordTranslator = changeRecordTranslator;
        this.duplicateValueBehavior = DuplicateValueBehavior.STRIP;
        this.trailingSpaceBehavior = TrailingSpaceBehavior.REJECT;
        this.relativeBasePath = DEFAULT_RELATIVE_BASE_PATH;
        if (numParseThreads == 0) {
            this.isAsync = false;
            this.asyncParser = null;
            this.asyncParsingComplete = null;
            this.asyncParsedRecords = null;
        } else {
            this.isAsync = true;
            this.asyncParsingComplete = new AtomicBoolean(false);
            LDAPSDKThreadFactory threadFactory = new LDAPSDKThreadFactory("LDIFReader Worker", true, null);
            ParallelProcessor<UnparsedLDIFRecord, LDIFRecord> parallelParser = new ParallelProcessor<UnparsedLDIFRecord, LDIFRecord>(new RecordParser(), threadFactory, numParseThreads, 3);
            ArrayBlockingQueue pendingQueue = new ArrayBlockingQueue(500);
            this.asyncParsedRecords = new ArrayBlockingQueue<Result<UnparsedLDIFRecord, LDIFRecord>>(1100);
            this.asyncParser = new AsynchronousParallelProcessor<UnparsedLDIFRecord, LDIFRecord>(pendingQueue, parallelParser, this.asyncParsedRecords);
            LineReaderThread lineReaderThread = new LineReaderThread();
            lineReaderThread.start();
        }
    }

    public static List<Entry> readEntries(String path) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(path));
    }

    public static List<Entry> readEntries(File file) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(file));
    }

    public static List<Entry> readEntries(InputStream inputStream) throws IOException, LDIFException {
        return LDIFReader.readEntries(new LDIFReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Entry> readEntries(LDIFReader reader) throws IOException, LDIFException {
        try {
            Entry e;
            ArrayList<Entry> entries = new ArrayList<Entry>(10);
            while ((e = reader.readEntry()) != null) {
                entries.add(e);
            }
            ArrayList<Entry> arrayList = entries;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.isAsync()) {
            this.asyncParsedRecords.clear();
        }
    }

    @Deprecated
    public boolean ignoreDuplicateValues() {
        return this.duplicateValueBehavior == DuplicateValueBehavior.STRIP;
    }

    @Deprecated
    public void setIgnoreDuplicateValues(boolean ignoreDuplicateValues) {
        this.duplicateValueBehavior = ignoreDuplicateValues ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT;
    }

    public DuplicateValueBehavior getDuplicateValueBehavior() {
        return this.duplicateValueBehavior;
    }

    public void setDuplicateValueBehavior(DuplicateValueBehavior duplicateValueBehavior) {
        this.duplicateValueBehavior = duplicateValueBehavior;
    }

    @Deprecated
    public boolean stripTrailingSpaces() {
        return this.trailingSpaceBehavior == TrailingSpaceBehavior.STRIP;
    }

    @Deprecated
    public void setStripTrailingSpaces(boolean stripTrailingSpaces) {
        this.trailingSpaceBehavior = stripTrailingSpaces ? TrailingSpaceBehavior.STRIP : TrailingSpaceBehavior.REJECT;
    }

    public TrailingSpaceBehavior getTrailingSpaceBehavior() {
        return this.trailingSpaceBehavior;
    }

    public void setTrailingSpaceBehavior(TrailingSpaceBehavior trailingSpaceBehavior) {
        this.trailingSpaceBehavior = trailingSpaceBehavior;
    }

    public String getRelativeBasePath() {
        return this.relativeBasePath;
    }

    public void setRelativeBasePath(String relativeBasePath) {
        this.setRelativeBasePath(new File(relativeBasePath));
    }

    public void setRelativeBasePath(File relativeBasePath) {
        String path = relativeBasePath.getAbsolutePath();
        this.relativeBasePath = path.endsWith(File.separator) ? path : path + File.separator;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public LDIFRecord readLDIFRecord() throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readLDIFRecordAsync();
        }
        return this.readLDIFRecordInternal();
    }

    public Entry readEntry() throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readEntryAsync();
        }
        return this.readEntryInternal();
    }

    public LDIFChangeRecord readChangeRecord() throws IOException, LDIFException {
        return this.readChangeRecord(false);
    }

    public LDIFChangeRecord readChangeRecord(boolean defaultAdd) throws IOException, LDIFException {
        if (this.isAsync()) {
            return this.readChangeRecordAsync(defaultAdd);
        }
        return this.readChangeRecordInternal(defaultAdd);
    }

    private LDIFRecord readLDIFRecordAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord record = null;
        while (record == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            record = result.getOutput();
            if (record != SKIP_ENTRY) continue;
            record = null;
        }
        return record;
    }

    private Entry readEntryAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord record = null;
        while (record == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            record = result.getOutput();
            if (record != SKIP_ENTRY) continue;
            record = null;
        }
        if (record instanceof Entry) {
            return (Entry)record;
        }
        if (record instanceof LDIFChangeRecord) {
            try {
                return ((LDIFChangeRecord)record).toEntry();
            }
            catch (LDIFException e) {
                Debug.debugException(e);
                long firstLineNumber = result.getInput().getFirstLineNumber();
                throw new LDIFException(e.getExceptionMessage(), firstLineNumber, true, e);
            }
        }
        throw new AssertionError((Object)"LDIFRecords must either be an Entry or an LDIFChangeRecord");
    }

    private LDIFChangeRecord readChangeRecordAsync(boolean defaultAdd) throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        LDIFRecord record = null;
        while (record == null) {
            result = this.readLDIFRecordResultAsync();
            if (result == null) {
                return null;
            }
            record = result.getOutput();
            if (record != SKIP_ENTRY) continue;
            record = null;
        }
        if (record instanceof LDIFChangeRecord) {
            return (LDIFChangeRecord)record;
        }
        if (record instanceof Entry) {
            if (defaultAdd) {
                return new LDIFAddChangeRecord((Entry)record);
            }
            long firstLineNumber = result.getInput().getFirstLineNumber();
            throw new LDIFException(LDIFMessages.ERR_READ_NOT_CHANGE_RECORD.get(firstLineNumber), firstLineNumber, true);
        }
        throw new AssertionError((Object)"LDIFRecords must either be an Entry or an LDIFChangeRecord");
    }

    private Result<UnparsedLDIFRecord, LDIFRecord> readLDIFRecordResultAsync() throws IOException, LDIFException {
        Result<UnparsedLDIFRecord, LDIFRecord> result = null;
        if (this.asyncParsingComplete.get()) {
            result = (Result<UnparsedLDIFRecord, LDIFRecord>)this.asyncParsedRecords.poll();
        } else {
            try {
                while (result == null && !this.asyncParsingComplete.get()) {
                    result = this.asyncParsedRecords.poll(1L, TimeUnit.SECONDS);
                }
                if (result == null) {
                    result = (Result)this.asyncParsedRecords.poll();
                }
            }
            catch (InterruptedException e) {
                Debug.debugException(e);
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        if (result == null) {
            return null;
        }
        LDIFReader.rethrow(result.getFailureCause());
        UnparsedLDIFRecord unparsedRecord = (UnparsedLDIFRecord)result.getInput();
        if (unparsedRecord.isEOF()) {
            this.asyncParsingComplete.set(true);
            try {
                this.asyncParsedRecords.put(result);
            }
            catch (InterruptedException e) {
                Debug.debugException(e);
                Thread.currentThread().interrupt();
            }
            return null;
        }
        return result;
    }

    private boolean isAsync() {
        return this.isAsync;
    }

    static void rethrow(Throwable t) throws IOException, LDIFException {
        if (t == null) {
            return;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof LDIFException) {
            throw (LDIFException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t);
    }

    private LDIFRecord readLDIFRecordInternal() throws IOException, LDIFException {
        UnparsedLDIFRecord unparsedRecord = this.readUnparsedRecord();
        return LDIFReader.decodeRecord(unparsedRecord, this.relativeBasePath, this.schema);
    }

    private Entry readEntryInternal() throws IOException, LDIFException {
        Entry e = null;
        while (e == null) {
            UnparsedLDIFRecord unparsedRecord = this.readUnparsedRecord();
            if (unparsedRecord.isEOF()) {
                return null;
            }
            e = LDIFReader.decodeEntry(unparsedRecord, this.relativeBasePath);
            Debug.debugLDIFRead(e);
            if (this.entryTranslator == null) continue;
            e = this.entryTranslator.translate(e, unparsedRecord.getFirstLineNumber());
        }
        return e;
    }

    private LDIFChangeRecord readChangeRecordInternal(boolean defaultAdd) throws IOException, LDIFException {
        LDIFChangeRecord r = null;
        while (r == null) {
            UnparsedLDIFRecord unparsedRecord = this.readUnparsedRecord();
            if (unparsedRecord.isEOF()) {
                return null;
            }
            r = LDIFReader.decodeChangeRecord(unparsedRecord, this.relativeBasePath, defaultAdd, this.schema);
            Debug.debugLDIFRead(r);
            if (this.changeRecordTranslator == null) continue;
            r = this.changeRecordTranslator.translate(r, unparsedRecord.getFirstLineNumber());
        }
        return r;
    }

    private UnparsedLDIFRecord readUnparsedRecord() throws IOException, LDIFException {
        ArrayList<StringBuilder> lineList = new ArrayList<StringBuilder>(20);
        boolean lastWasComment = false;
        long firstLineNumber = this.lineNumberCounter + 1L;
        while (true) {
            String line = this.reader.readLine();
            ++this.lineNumberCounter;
            if (line == null) {
                if (!lineList.isEmpty()) break;
                return new UnparsedLDIFRecord(new ArrayList(0), this.duplicateValueBehavior, this.trailingSpaceBehavior, this.schema, -1L);
            }
            if (line.length() == 0) {
                lastWasComment = false;
                if (!lineList.isEmpty()) break;
                ++firstLineNumber;
                continue;
            }
            if (line.charAt(0) == ' ') {
                if (lastWasComment) continue;
                if (lineList.isEmpty()) {
                    throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_FIRST_SPACE.get(this.lineNumberCounter), this.lineNumberCounter, false);
                }
                ((StringBuilder)lineList.get(lineList.size() - 1)).append(line.substring(1));
                lastWasComment = false;
                continue;
            }
            if (line.charAt(0) == '#') {
                lastWasComment = true;
                continue;
            }
            if (lineList.isEmpty() && line.startsWith("version:")) {
                lastWasComment = true;
                continue;
            }
            lineList.add(new StringBuilder(line));
            lastWasComment = false;
        }
        return new UnparsedLDIFRecord(lineList, this.duplicateValueBehavior, this.trailingSpaceBehavior, this.schema, firstLineNumber);
    }

    public static Entry decodeEntry(String ... ldifLines) throws LDIFException {
        Entry e = LDIFReader.decodeEntry(LDIFReader.prepareRecord(DuplicateValueBehavior.STRIP, TrailingSpaceBehavior.REJECT, null, ldifLines), DEFAULT_RELATIVE_BASE_PATH);
        Debug.debugLDIFRead(e);
        return e;
    }

    public static Entry decodeEntry(boolean ignoreDuplicateValues, Schema schema, String ... ldifLines) throws LDIFException {
        return LDIFReader.decodeEntry(ignoreDuplicateValues, TrailingSpaceBehavior.REJECT, schema, ldifLines);
    }

    public static Entry decodeEntry(boolean ignoreDuplicateValues, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, String ... ldifLines) throws LDIFException {
        Entry e = LDIFReader.decodeEntry(LDIFReader.prepareRecord(ignoreDuplicateValues ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT, trailingSpaceBehavior, schema, ldifLines), DEFAULT_RELATIVE_BASE_PATH);
        Debug.debugLDIFRead(e);
        return e;
    }

    public static LDIFChangeRecord decodeChangeRecord(String ... ldifLines) throws LDIFException {
        return LDIFReader.decodeChangeRecord(false, ldifLines);
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean defaultAdd, String ... ldifLines) throws LDIFException {
        LDIFChangeRecord r = LDIFReader.decodeChangeRecord(LDIFReader.prepareRecord(DuplicateValueBehavior.STRIP, TrailingSpaceBehavior.REJECT, null, ldifLines), DEFAULT_RELATIVE_BASE_PATH, defaultAdd, null);
        Debug.debugLDIFRead(r);
        return r;
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean ignoreDuplicateValues, Schema schema, boolean defaultAdd, String ... ldifLines) throws LDIFException {
        return LDIFReader.decodeChangeRecord(ignoreDuplicateValues, TrailingSpaceBehavior.REJECT, schema, defaultAdd, ldifLines);
    }

    public static LDIFChangeRecord decodeChangeRecord(boolean ignoreDuplicateValues, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, boolean defaultAdd, String ... ldifLines) throws LDIFException {
        LDIFChangeRecord r = LDIFReader.decodeChangeRecord(LDIFReader.prepareRecord(ignoreDuplicateValues ? DuplicateValueBehavior.STRIP : DuplicateValueBehavior.REJECT, trailingSpaceBehavior, schema, ldifLines), DEFAULT_RELATIVE_BASE_PATH, defaultAdd, null);
        Debug.debugLDIFRead(r);
        return r;
    }

    private static UnparsedLDIFRecord prepareRecord(DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, String ... ldifLines) throws LDIFException {
        Validator.ensureNotNull(ldifLines);
        Validator.ensureFalse(ldifLines.length == 0, "LDIFReader.prepareRecord.ldifLines must not be empty.");
        boolean lastWasComment = false;
        ArrayList<StringBuilder> lineList = new ArrayList<StringBuilder>(ldifLines.length);
        for (int i = 0; i < ldifLines.length; ++i) {
            int j;
            String line = ldifLines[i];
            if (line.length() == 0 && (j = i + 1) < ldifLines.length) {
                if (ldifLines[j].length() > 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_BLANK.get(i), (long)i, true, ldifLines, null);
                }
                if (lineList.isEmpty()) {
                    throw new LDIFException(LDIFMessages.ERR_READ_ONLY_BLANKS.get(), 0L, true, ldifLines, null);
                }
                return new UnparsedLDIFRecord(lineList, duplicateValueBehavior, trailingSpaceBehavior, schema, 0L);
            }
            if (line.charAt(0) == ' ') {
                if (i > 0) {
                    if (lastWasComment) continue;
                    ((StringBuilder)lineList.get(lineList.size() - 1)).append(line.substring(1));
                    continue;
                }
                throw new LDIFException(LDIFMessages.ERR_READ_UNEXPECTED_FIRST_SPACE_NO_NUMBER.get(), 0L, true, ldifLines, null);
            }
            if (line.charAt(0) == '#') {
                lastWasComment = true;
                continue;
            }
            lineList.add(new StringBuilder(line));
            lastWasComment = false;
        }
        if (lineList.isEmpty()) {
            throw new LDIFException(LDIFMessages.ERR_READ_NO_DATA.get(), 0L, true, ldifLines, null);
        }
        return new UnparsedLDIFRecord(lineList, duplicateValueBehavior, trailingSpaceBehavior, schema, 0L);
    }

    private static LDIFRecord decodeRecord(UnparsedLDIFRecord unparsedRecord, String relativeBasePath, Schema schema) throws LDIFException {
        String lowerSecondLine;
        Exception readError = unparsedRecord.getFailureCause();
        if (readError != null) {
            if (readError instanceof LDIFException) {
                LDIFException ldifEx = (LDIFException)readError;
                throw new LDIFException(ldifEx.getMessage(), ldifEx.getLineNumber(), ldifEx.mayContinueReading(), ldifEx.getDataLines(), ldifEx.getCause());
            }
            throw new LDIFException(StaticUtils.getExceptionMessage(readError), -1L, true, readError);
        }
        if (unparsedRecord.isEOF()) {
            return null;
        }
        ArrayList lineList = unparsedRecord.getLineList();
        if (unparsedRecord.getLineList() == null) {
            return null;
        }
        LDIFRecord r = lineList.size() == 1 ? LDIFReader.decodeEntry(unparsedRecord, relativeBasePath) : ((lowerSecondLine = StaticUtils.toLowerCase(((StringBuilder)lineList.get(1)).toString())).startsWith("control:") || lowerSecondLine.startsWith("changetype:") ? LDIFReader.decodeChangeRecord(unparsedRecord, relativeBasePath, true, schema) : LDIFReader.decodeEntry(unparsedRecord, relativeBasePath));
        Debug.debugLDIFRead(r);
        return r;
    }

    private static Entry decodeEntry(UnparsedLDIFRecord unparsedRecord, String relativeBasePath) throws LDIFException {
        String dn;
        ArrayList ldifLines = unparsedRecord.getLineList();
        long firstLineNumber = unparsedRecord.getFirstLineNumber();
        Iterator<StringBuilder> iterator = ldifLines.iterator();
        StringBuilder line = (StringBuilder)iterator.next();
        LDIFReader.handleTrailingSpaces(line, null, firstLineNumber, unparsedRecord.getTrailingSpaceBehavior());
        int colonPos = line.indexOf(":");
        if (colonPos > 0 && line.substring(0, colonPos).equalsIgnoreCase("version")) {
            line = (StringBuilder)iterator.next();
            LDIFReader.handleTrailingSpaces(line, null, firstLineNumber, unparsedRecord.getTrailingSpaceBehavior());
        }
        if ((colonPos = line.indexOf(":")) < 0 || !line.substring(0, colonPos).equalsIgnoreCase("dn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_DN_LINE_DOESNT_START_WITH_DN.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        int length = line.length();
        if (length == colonPos + 1) {
            dn = "";
        } else if (line.charAt(colonPos + 1) == ':') {
            int pos;
            for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            try {
                byte[] dnBytes = Base64.decode(line.substring(pos));
                dn = new String(dnBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_DN.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_DN.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        } else {
            int pos;
            for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            dn = line.substring(pos);
        }
        if (!iterator.hasNext()) {
            return new Entry(dn, unparsedRecord.getSchema());
        }
        return new Entry(dn, unparsedRecord.getSchema(), LDIFReader.parseAttributes(dn, unparsedRecord.getDuplicateValueBehavior(), unparsedRecord.getTrailingSpaceBehavior(), unparsedRecord.getSchema(), ldifLines, iterator, relativeBasePath, firstLineNumber));
    }

    private static LDIFChangeRecord decodeChangeRecord(UnparsedLDIFRecord unparsedRecord, String relativeBasePath, boolean defaultAdd, Schema schema) throws LDIFException {
        int pos;
        String dn;
        ArrayList ldifLines = unparsedRecord.getLineList();
        long firstLineNumber = unparsedRecord.getFirstLineNumber();
        Iterator<StringBuilder> iterator = ldifLines.iterator();
        StringBuilder line = (StringBuilder)iterator.next();
        LDIFReader.handleTrailingSpaces(line, null, firstLineNumber, unparsedRecord.getTrailingSpaceBehavior());
        int colonPos = line.indexOf(":");
        int linesRead = 1;
        if (colonPos > 0 && line.substring(0, colonPos).equalsIgnoreCase("version")) {
            line = (StringBuilder)iterator.next();
            ++linesRead;
            LDIFReader.handleTrailingSpaces(line, null, firstLineNumber, unparsedRecord.getTrailingSpaceBehavior());
        }
        if ((colonPos = line.indexOf(":")) < 0 || !line.substring(0, colonPos).equalsIgnoreCase("dn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_DN_LINE_DOESNT_START_WITH_DN.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        int length = line.length();
        if (length == colonPos + 1) {
            dn = "";
        } else if (line.charAt(colonPos + 1) == ':') {
            for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            try {
                byte[] dnBytes = Base64.decode(line.substring(pos));
                dn = new String(dnBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CANNOT_BASE64_DECODE_DN.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CANNOT_BASE64_DECODE_DN.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        } else {
            for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            dn = line.substring(pos);
        }
        if (!iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_CR_TOO_SHORT.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        String changeType = null;
        ArrayList<Control> controls = null;
        while (true) {
            line = (StringBuilder)iterator.next();
            LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, unparsedRecord.getTrailingSpaceBehavior());
            colonPos = line.indexOf(":");
            if (colonPos < 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_CR_SECOND_LINE_MISSING_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            String token = StaticUtils.toLowerCase(line.substring(0, colonPos));
            if (token.equals("control")) {
                if (controls == null) {
                    controls = new ArrayList<Control>(5);
                }
            } else {
                if (token.equals("changetype")) {
                    changeType = LDIFReader.decodeChangeType(line, colonPos, firstLineNumber, ldifLines);
                    break;
                }
                if (defaultAdd) {
                    changeType = "add";
                    iterator = ldifLines.iterator();
                    for (int i = 0; i < linesRead; ++i) {
                        iterator.next();
                    }
                    break;
                }
                throw new LDIFException(LDIFMessages.ERR_READ_CR_CT_LINE_DOESNT_START_WITH_CONTROL_OR_CT.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            controls.add(LDIFReader.decodeControl(line, colonPos, firstLineNumber, ldifLines, relativeBasePath));
            ++linesRead;
        }
        String lowerChangeType = StaticUtils.toLowerCase(changeType);
        if (lowerChangeType.equals("add")) {
            if (iterator.hasNext()) {
                ArrayList<Attribute> attrs = LDIFReader.parseAttributes(dn, unparsedRecord.getDuplicateValueBehavior(), unparsedRecord.getTrailingSpaceBehavior(), unparsedRecord.getSchema(), ldifLines, iterator, relativeBasePath, firstLineNumber);
                Attribute[] attributes = new Attribute[attrs.size()];
                Iterator attrIterator = attrs.iterator();
                for (int i = 0; i < attributes.length; ++i) {
                    attributes[i] = (Attribute)attrIterator.next();
                }
                return new LDIFAddChangeRecord(dn, attributes, controls);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_ATTRIBUTES.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (lowerChangeType.equals("delete")) {
            if (iterator.hasNext()) {
                throw new LDIFException(LDIFMessages.ERR_READ_CR_EXTRA_DELETE_DATA.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            return new LDIFDeleteChangeRecord(dn, controls);
        }
        if (lowerChangeType.equals("modify")) {
            if (iterator.hasNext()) {
                Modification[] mods = LDIFReader.parseModifications(dn, unparsedRecord.getTrailingSpaceBehavior(), ldifLines, iterator, firstLineNumber, schema);
                return new LDIFModifyChangeRecord(dn, mods, controls);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_MODS.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (lowerChangeType.equals("moddn") || lowerChangeType.equals("modrdn")) {
            if (iterator.hasNext()) {
                return LDIFReader.parseModifyDNChangeRecord(ldifLines, iterator, dn, controls, unparsedRecord.getTrailingSpaceBehavior(), firstLineNumber);
            }
            throw new LDIFException(LDIFMessages.ERR_READ_CR_NO_NEWRDN.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        throw new LDIFException(LDIFMessages.ERR_READ_CR_INVALID_CT.get(changeType, firstLineNumber), firstLineNumber, true, ldifLines, null);
    }

    private static Control decodeControl(StringBuilder line, int colonPos, long firstLineNumber, ArrayList<StringBuilder> ldifLines, String relativeBasePath) throws LDIFException {
        ASN1OctetString value;
        boolean isCritical;
        int pos;
        String controlString;
        int pos2;
        int length = line.length();
        if (length == colonPos + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_NO_CONTROL_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (line.charAt(colonPos + 1) == ':') {
            for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            try {
                byte[] controlBytes = Base64.decode(line.substring(pos2));
                controlString = new String(controlBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CONTROL.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CONTROL.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        } else {
            for (pos2 = colonPos + 1; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            controlString = line.substring(pos2);
        }
        if (controlString.length() == 0) {
            throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_NO_CONTROL_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        String oid = null;
        boolean hasCriticality = false;
        boolean hasValue = false;
        length = controlString.length();
        for (pos = 0; pos < length; ++pos) {
            char c = controlString.charAt(pos);
            if (c == ':') {
                oid = controlString.substring(0, pos++);
                hasValue = true;
                break;
            }
            if (c != ' ') continue;
            oid = controlString.substring(0, pos++);
            hasCriticality = true;
            break;
        }
        if (oid == null) {
            return new Control(controlString, false);
        }
        if (hasCriticality) {
            String criticalityString;
            while (controlString.charAt(pos) == ' ') {
                ++pos;
            }
            int criticalityStartPos = pos;
            while (pos < length) {
                char c = controlString.charAt(pos);
                if (c == ':') {
                    hasValue = true;
                    break;
                }
                ++pos;
            }
            if ((criticalityString = StaticUtils.toLowerCase(controlString.substring(criticalityStartPos, pos))).equals("true")) {
                isCritical = true;
            } else if (criticalityString.equals("false")) {
                isCritical = false;
            } else {
                throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_INVALID_CRITICALITY.get(criticalityString, firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            if (hasValue) {
                ++pos;
            }
        } else {
            isCritical = false;
        }
        if (hasValue) {
            switch (controlString.charAt(pos)) {
                case ':': {
                    try {
                        if (controlString.length() == pos + 1) {
                            value = new ASN1OctetString();
                            break;
                        }
                        if (controlString.charAt(pos + 1) == ' ') {
                            value = new ASN1OctetString(Base64.decode(controlString.substring(pos + 2)));
                            break;
                        }
                        value = new ASN1OctetString(Base64.decode(controlString.substring(pos + 1)));
                        break;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_CANNOT_BASE64_DECODE_VALUE.get(firstLineNumber, StaticUtils.getExceptionMessage(e)), firstLineNumber, true, ldifLines, (Throwable)e);
                    }
                }
                case '<': {
                    try {
                        String urlString = controlString.charAt(pos + 1) == ' ' ? controlString.substring(pos + 2) : controlString.substring(pos + 1);
                        value = new ASN1OctetString(LDIFReader.retrieveURLBytes(urlString, relativeBasePath, firstLineNumber));
                        break;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDIFException(LDIFMessages.ERR_READ_CONTROL_LINE_CANNOT_RETRIEVE_VALUE_FROM_URL.get(firstLineNumber, StaticUtils.getExceptionMessage(e)), firstLineNumber, true, ldifLines, (Throwable)e);
                    }
                }
                case ' ': {
                    value = new ASN1OctetString(controlString.substring(pos + 1));
                    break;
                }
                default: {
                    value = new ASN1OctetString(controlString.substring(pos));
                    break;
                }
            }
        } else {
            value = null;
        }
        return new Control(oid, isCritical, value);
    }

    private static String decodeChangeType(StringBuilder line, int colonPos, long firstLineNumber, ArrayList<StringBuilder> ldifLines) throws LDIFException {
        int pos;
        int length = line.length();
        if (length == colonPos + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_CT_LINE_NO_CT_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (line.charAt(colonPos + 1) == ':') {
            int pos2;
            for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            try {
                byte[] changeTypeBytes = Base64.decode(line.substring(pos2));
                return new String(changeTypeBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CT.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_CT.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        }
        for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
        }
        return line.substring(pos);
    }

    private static ArrayList<Attribute> parseAttributes(String dn, DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, ArrayList<StringBuilder> ldifLines, Iterator<StringBuilder> iterator, String relativeBasePath, long firstLineNumber) throws LDIFException {
        LinkedHashMap<String, Serializable> attributes = new LinkedHashMap<String, Serializable>(ldifLines.size());
        while (iterator.hasNext()) {
            int pos;
            LDIFAttribute ldifAttr;
            Attribute attr;
            StringBuilder line = iterator.next();
            LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
            int colonPos = line.indexOf(":");
            if (colonPos <= 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_NO_ATTR_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            String attributeName = line.substring(0, colonPos);
            String lowerName = StaticUtils.toLowerCase(attributeName);
            MatchingRule matchingRule = schema == null ? CaseIgnoreStringMatchingRule.getInstance() : MatchingRule.selectEqualityMatchingRule(attributeName, schema);
            Object attrObject = attributes.get(lowerName);
            if (attrObject == null) {
                attr = null;
                ldifAttr = null;
            } else if (attrObject instanceof Attribute) {
                attr = (Attribute)attrObject;
                ldifAttr = new LDIFAttribute(attr.getName(), matchingRule, attr.getRawValues()[0]);
                attributes.put(lowerName, ldifAttr);
            } else {
                attr = null;
                ldifAttr = (LDIFAttribute)attrObject;
            }
            int length = line.length();
            if (length == colonPos + 1) {
                if (attrObject == null) {
                    attr = new Attribute(attributeName, matchingRule, "");
                    attributes.put(lowerName, attr);
                    continue;
                }
                try {
                    if (ldifAttr.addValue(new ASN1OctetString(), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                    throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(dn, firstLineNumber, attributeName), firstLineNumber, true, ldifLines, null);
                }
                catch (LDAPException le) {
                    throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(dn, firstLineNumber, attributeName, StaticUtils.getExceptionMessage(le)), firstLineNumber, true, ldifLines, (Throwable)le);
                }
            }
            if (line.charAt(colonPos + 1) == ':') {
                for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
                }
                try {
                    byte[] valueBytes = Base64.decode(line.substring(pos));
                    if (attrObject == null) {
                        attr = new Attribute(attributeName, matchingRule, valueBytes);
                        attributes.put(lowerName, attr);
                        continue;
                    }
                    try {
                        if (ldifAttr.addValue(new ASN1OctetString(valueBytes), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                        throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(dn, firstLineNumber, attributeName), firstLineNumber, true, ldifLines, null);
                    }
                    catch (LDAPException le) {
                        throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(dn, firstLineNumber, attributeName, StaticUtils.getExceptionMessage(le)), firstLineNumber, true, ldifLines, (Throwable)le);
                    }
                }
                catch (ParseException pe) {
                    Debug.debugException(pe);
                    throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(attributeName, firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
                }
            }
            if (line.charAt(colonPos + 1) == '<') {
                byte[] urlBytes;
                for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
                }
                String urlString = line.substring(pos);
                try {
                    urlBytes = LDIFReader.retrieveURLBytes(urlString, relativeBasePath, firstLineNumber);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_EXCEPTION.get(attributeName, urlString, firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
                }
                if (attrObject == null) {
                    attr = new Attribute(attributeName, matchingRule, urlBytes);
                    attributes.put(lowerName, attr);
                    continue;
                }
                try {
                    if (ldifAttr.addValue(new ASN1OctetString(urlBytes), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                    throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(dn, firstLineNumber, attributeName), firstLineNumber, true, ldifLines, null);
                }
                catch (LDIFException le) {
                    Debug.debugException(le);
                    throw le;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_EXCEPTION.get(attributeName, urlString, firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
                }
            }
            for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            String valueString = line.substring(pos);
            if (attrObject == null) {
                attr = new Attribute(attributeName, matchingRule, valueString);
                attributes.put(lowerName, attr);
                continue;
            }
            try {
                if (ldifAttr.addValue(new ASN1OctetString(valueString), duplicateValueBehavior) || duplicateValueBehavior == DuplicateValueBehavior.STRIP) continue;
                throw new LDIFException(LDIFMessages.ERR_READ_DUPLICATE_VALUE.get(dn, firstLineNumber, attributeName), firstLineNumber, true, ldifLines, null);
            }
            catch (LDAPException le) {
                throw new LDIFException(LDIFMessages.ERR_READ_VALUE_SYNTAX_VIOLATION.get(dn, firstLineNumber, attributeName, StaticUtils.getExceptionMessage(le)), firstLineNumber, true, ldifLines, (Throwable)le);
            }
        }
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(attributes.size());
        for (Object o : attributes.values()) {
            if (o instanceof Attribute) {
                attrList.add((Attribute)o);
                continue;
            }
            attrList.add(((LDIFAttribute)o).toAttribute());
        }
        return attrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] retrieveURLBytes(String urlString, String relativeBasePath, long firstLineNumber) throws LDIFException, IOException {
        String path;
        String lowerURLString = StaticUtils.toLowerCase(urlString);
        if (lowerURLString.startsWith("file:/")) {
            int pos;
            for (pos = 6; pos < urlString.length() && urlString.charAt(pos) == '/'; ++pos) {
            }
            path = urlString.substring(pos - 1);
        } else if (lowerURLString.startsWith("file:")) {
            path = relativeBasePath + urlString.substring(5);
        } else {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_INVALID_SCHEME.get(urlString), firstLineNumber, true);
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_NO_SUCH_FILE.get(urlString, f.getAbsolutePath()), firstLineNumber, true);
        }
        long fileSize = f.length();
        if (fileSize > 0xA00000L) {
            throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_TOO_LARGE.get(urlString, f.getAbsolutePath(), 0xA00000), firstLineNumber, true);
        }
        int fileBytesRemaining = (int)fileSize;
        byte[] fileData = new byte[(int)fileSize];
        try (FileInputStream fis = new FileInputStream(f);){
            int fileBytesRead = 0;
            while ((long)fileBytesRead < fileSize) {
                int bytesRead = fis.read(fileData, fileBytesRead, fileBytesRemaining);
                if (bytesRead < 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_SIZE_CHANGED.get(urlString, f.getAbsolutePath()), firstLineNumber, true);
                }
                fileBytesRead += bytesRead;
                fileBytesRemaining -= bytesRead;
            }
            if (fis.read() != -1) {
                throw new LDIFException(LDIFMessages.ERR_READ_URL_FILE_SIZE_CHANGED.get(urlString, f.getAbsolutePath()), firstLineNumber, true);
            }
        }
        return fileData;
    }

    private static Modification[] parseModifications(String dn, TrailingSpaceBehavior trailingSpaceBehavior, ArrayList<StringBuilder> ldifLines, Iterator<StringBuilder> iterator, long firstLineNumber, Schema schema) throws LDIFException {
        ArrayList<Modification> modList = new ArrayList<Modification>(ldifLines.size());
        while (iterator.hasNext()) {
            String attributeName;
            int pos;
            ModificationType modType;
            StringBuilder line = iterator.next();
            LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
            int colonPos = line.indexOf(":");
            if (colonPos < 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_NO_MODTYPE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            String modTypeStr = StaticUtils.toLowerCase(line.substring(0, colonPos));
            if (modTypeStr.equals("add")) {
                modType = ModificationType.ADD;
            } else if (modTypeStr.equals("delete")) {
                modType = ModificationType.DELETE;
            } else if (modTypeStr.equals("replace")) {
                modType = ModificationType.REPLACE;
            } else if (modTypeStr.equals("increment")) {
                modType = ModificationType.INCREMENT;
            } else {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_INVALID_MODTYPE.get(modTypeStr, firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            int length = line.length();
            if (length == colonPos + 1) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_NO_ATTR.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            if (line.charAt(colonPos + 1) == ':') {
                for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
                }
                try {
                    byte[] dnBytes = Base64.decode(line.substring(pos));
                    attributeName = new String(dnBytes, "UTF-8");
                }
                catch (ParseException pe) {
                    Debug.debugException(pe);
                    throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_CANNOT_BASE64_DECODE_ATTR.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_CANNOT_BASE64_DECODE_ATTR.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
                }
            } else {
                for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
                }
                attributeName = line.substring(pos);
            }
            if (attributeName.length() == 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_MODTYPE_NO_ATTR.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(ldifLines.size());
            while (iterator.hasNext()) {
                int pos2;
                ASN1OctetString value;
                line = iterator.next();
                LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
                if (line.toString().equals("-")) break;
                colonPos = line.indexOf(":");
                if (colonPos < 0) {
                    throw new LDIFException(LDIFMessages.ERR_READ_NO_ATTR_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
                }
                if (!line.substring(0, colonPos).equalsIgnoreCase(attributeName)) {
                    String alternateName = line.substring(0, colonPos);
                    boolean baseNameEquivalent = false;
                    String expectedBaseName = Attribute.getBaseName(attributeName);
                    String alternateBaseName = Attribute.getBaseName(alternateName);
                    if (alternateBaseName.equalsIgnoreCase(expectedBaseName)) {
                        baseNameEquivalent = true;
                    } else if (schema != null) {
                        AttributeTypeDefinition expectedAT = schema.getAttributeType(expectedBaseName);
                        AttributeTypeDefinition alternateAT = schema.getAttributeType(alternateBaseName);
                        if (expectedAT != null && alternateAT != null && expectedAT.equals(alternateAT)) {
                            baseNameEquivalent = true;
                        }
                    }
                    Set<String> expectedOptions = Attribute.getOptions(attributeName);
                    HashSet<String> lowerExpectedOptions = new HashSet<String>(expectedOptions.size());
                    for (String s : expectedOptions) {
                        lowerExpectedOptions.add(StaticUtils.toLowerCase(s));
                    }
                    Set<String> alternateOptions = Attribute.getOptions(alternateName);
                    HashSet<String> lowerAlternateOptions = new HashSet<String>(alternateOptions.size());
                    for (String s : alternateOptions) {
                        lowerAlternateOptions.add(StaticUtils.toLowerCase(s));
                    }
                    boolean optionsEquivalent = lowerAlternateOptions.equals(lowerExpectedOptions);
                    if (!baseNameEquivalent || !optionsEquivalent) {
                        if (valueList.isEmpty() && baseNameEquivalent && lowerAlternateOptions.remove("binary") && lowerAlternateOptions.equals(lowerExpectedOptions)) {
                            attributeName = alternateName;
                        } else {
                            throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_ATTR_MISMATCH.get(firstLineNumber, line.substring(0, colonPos), attributeName), firstLineNumber, true, ldifLines, null);
                        }
                    }
                }
                if ((length = line.length()) == colonPos + 1) {
                    value = new ASN1OctetString();
                } else if (line.charAt(colonPos + 1) == ':') {
                    for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
                    }
                    try {
                        value = new ASN1OctetString(Base64.decode(line.substring(pos2)));
                    }
                    catch (ParseException pe) {
                        Debug.debugException(pe);
                        throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(attributeName, firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDIFException(LDIFMessages.ERR_READ_CANNOT_BASE64_DECODE_ATTR.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
                    }
                } else {
                    for (pos2 = colonPos + 1; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
                    }
                    value = new ASN1OctetString(line.substring(pos2));
                }
                valueList.add(value);
            }
            ASN1OctetString[] values = new ASN1OctetString[valueList.size()];
            valueList.toArray(values);
            if (modType.intValue() == ModificationType.ADD.intValue() && values.length == 0) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_NO_ADD_VALUES.get(attributeName, firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            if (modType.intValue() == ModificationType.INCREMENT.intValue() && values.length != 1) {
                throw new LDIFException(LDIFMessages.ERR_READ_MOD_CR_INVALID_INCR_VALUE_COUNT.get(firstLineNumber, attributeName), firstLineNumber, true, ldifLines, null);
            }
            modList.add(new Modification(modType, attributeName, values));
        }
        Modification[] mods = new Modification[modList.size()];
        modList.toArray(mods);
        return mods;
    }

    private static LDIFModifyDNChangeRecord parseModifyDNChangeRecord(ArrayList<StringBuilder> ldifLines, Iterator<StringBuilder> iterator, String dn, List<Control> controls, TrailingSpaceBehavior trailingSpaceBehavior, long firstLineNumber) throws LDIFException {
        String newSuperiorDN;
        boolean deleteOldRDN;
        String deleteOldRDNStr;
        int pos;
        String newRDN;
        int pos2;
        StringBuilder line = iterator.next();
        LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
        int colonPos = line.indexOf(":");
        if (colonPos < 0 || !line.substring(0, colonPos).equalsIgnoreCase("newrdn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        int length = line.length();
        if (length == colonPos + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (line.charAt(colonPos + 1) == ':') {
            for (pos2 = colonPos + 2; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            try {
                byte[] dnBytes = Base64.decode(line.substring(pos2));
                newRDN = new String(dnBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWRDN.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWRDN.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        } else {
            for (pos2 = colonPos + 1; pos2 < length && line.charAt(pos2) == ' '; ++pos2) {
            }
            newRDN = line.substring(pos2);
        }
        if (newRDN.length() == 0) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWRDN_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (!iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        line = iterator.next();
        LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
        colonPos = line.indexOf(":");
        if (colonPos < 0 || !line.substring(0, colonPos).equalsIgnoreCase("deleteoldrdn")) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        length = line.length();
        if (length == colonPos + 1) {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_DELOLDRDN_VALUE.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (line.charAt(colonPos + 1) == ':') {
            for (pos = colonPos + 2; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            try {
                byte[] changeTypeBytes = Base64.decode(line.substring(pos));
                deleteOldRDNStr = new String(changeTypeBytes, "UTF-8");
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_DELOLDRDN.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_DELOLDRDN.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
            }
        } else {
            for (pos = colonPos + 1; pos < length && line.charAt(pos) == ' '; ++pos) {
            }
            deleteOldRDNStr = line.substring(pos);
        }
        if (deleteOldRDNStr.equals("0")) {
            deleteOldRDN = false;
        } else if (deleteOldRDNStr.equals("1")) {
            deleteOldRDN = true;
        } else if (deleteOldRDNStr.equalsIgnoreCase("false") || deleteOldRDNStr.equalsIgnoreCase("no")) {
            deleteOldRDN = false;
        } else if (deleteOldRDNStr.equalsIgnoreCase("true") || deleteOldRDNStr.equalsIgnoreCase("yes")) {
            deleteOldRDN = false;
        } else {
            throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_INVALID_DELOLDRDN.get(deleteOldRDNStr, firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        if (iterator.hasNext()) {
            line = iterator.next();
            LDIFReader.handleTrailingSpaces(line, dn, firstLineNumber, trailingSpaceBehavior);
            colonPos = line.indexOf(":");
            if (colonPos < 0 || !line.substring(0, colonPos).equalsIgnoreCase("newsuperior")) {
                throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_NO_NEWSUPERIOR_COLON.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
            }
            length = line.length();
            if (length == colonPos + 1) {
                newSuperiorDN = "";
            } else if (line.charAt(colonPos + 1) == ':') {
                int pos3;
                for (pos3 = colonPos + 2; pos3 < length && line.charAt(pos3) == ' '; ++pos3) {
                }
                try {
                    byte[] dnBytes = Base64.decode(line.substring(pos3));
                    newSuperiorDN = new String(dnBytes, "UTF-8");
                }
                catch (ParseException pe) {
                    Debug.debugException(pe);
                    throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWSUPERIOR.get(firstLineNumber, pe.getMessage()), firstLineNumber, true, ldifLines, (Throwable)pe);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDIFException(LDIFMessages.ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWSUPERIOR.get(firstLineNumber, e), firstLineNumber, true, ldifLines, (Throwable)e);
                }
            } else {
                int pos4;
                for (pos4 = colonPos + 1; pos4 < length && line.charAt(pos4) == ' '; ++pos4) {
                }
                newSuperiorDN = line.substring(pos4);
            }
        } else {
            newSuperiorDN = null;
        }
        if (iterator.hasNext()) {
            throw new LDIFException(LDIFMessages.ERR_READ_CR_EXTRA_MODDN_DATA.get(firstLineNumber), firstLineNumber, true, ldifLines, null);
        }
        return new LDIFModifyDNChangeRecord(dn, newRDN, deleteOldRDN, newSuperiorDN, controls);
    }

    private static void handleTrailingSpaces(StringBuilder buffer, String dn, long firstLineNumber, TrailingSpaceBehavior trailingSpaceBehavior) throws LDIFException {
        int pos;
        boolean trailingFound = false;
        for (pos = buffer.length() - 1; pos >= 0 && buffer.charAt(pos) == ' '; --pos) {
            trailingFound = true;
        }
        if (trailingFound && buffer.charAt(pos) != ':') {
            switch (trailingSpaceBehavior) {
                case STRIP: {
                    buffer.setLength(pos + 1);
                    break;
                }
                case REJECT: {
                    if (dn == null) {
                        throw new LDIFException(LDIFMessages.ERR_READ_ILLEGAL_TRAILING_SPACE_WITHOUT_DN.get(firstLineNumber, buffer.toString()), firstLineNumber, true);
                    }
                    throw new LDIFException(LDIFMessages.ERR_READ_ILLEGAL_TRAILING_SPACE_WITH_DN.get(dn, firstLineNumber, buffer.toString()), firstLineNumber, true);
                }
            }
        }
    }

    static {
        String currentDirString = System.getProperty("user.dir");
        File currentDir = currentDirString == null ? new File(".") : new File(currentDirString);
        String currentDirAbsolutePath = currentDir.getAbsolutePath();
        DEFAULT_RELATIVE_BASE_PATH = currentDirAbsolutePath.endsWith(File.separator) ? currentDirAbsolutePath : currentDirAbsolutePath + File.separator;
    }

    private final class RecordParser
    implements Processor<UnparsedLDIFRecord, LDIFRecord> {
        private RecordParser() {
        }

        @Override
        public LDIFRecord process(UnparsedLDIFRecord input) throws LDIFException {
            LDIFRecord record = LDIFReader.decodeRecord(input, LDIFReader.this.relativeBasePath, LDIFReader.this.schema);
            if (record instanceof Entry && LDIFReader.this.entryTranslator != null && (record = LDIFReader.this.entryTranslator.translate((Entry)record, input.getFirstLineNumber())) == null) {
                record = SKIP_ENTRY;
            }
            if (record instanceof LDIFChangeRecord && LDIFReader.this.changeRecordTranslator != null && (record = LDIFReader.this.changeRecordTranslator.translate((LDIFChangeRecord)record, input.getFirstLineNumber())) == null) {
                record = SKIP_ENTRY;
            }
            return record;
        }
    }

    private final class LineReaderThread
    extends Thread {
        private LineReaderThread() {
            super("Asynchronous LDIF line reader");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                boolean stopProcessing = false;
                while (!stopProcessing) {
                    UnparsedLDIFRecord unparsedRecord = null;
                    try {
                        unparsedRecord = LDIFReader.this.readUnparsedRecord();
                    }
                    catch (IOException e) {
                        Debug.debugException(e);
                        unparsedRecord = new UnparsedLDIFRecord(e);
                        stopProcessing = true;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        unparsedRecord = new UnparsedLDIFRecord(e);
                    }
                    try {
                        LDIFReader.this.asyncParser.submit(unparsedRecord);
                    }
                    catch (InterruptedException e) {
                        Debug.debugException(e);
                        Thread.currentThread().interrupt();
                        stopProcessing = true;
                    }
                    if (unparsedRecord != null && !unparsedRecord.isEOF()) continue;
                    stopProcessing = true;
                }
                return;
            }
            finally {
                try {
                    LDIFReader.this.asyncParser.shutdown();
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    LDIFReader.this.asyncParsingComplete.set(true);
                }
            }
        }
    }

    private static final class UnparsedLDIFRecord {
        private final ArrayList<StringBuilder> lineList;
        private final long firstLineNumber;
        private final Exception failureCause;
        private final boolean isEOF;
        private final DuplicateValueBehavior duplicateValueBehavior;
        private final Schema schema;
        private final TrailingSpaceBehavior trailingSpaceBehavior;

        private UnparsedLDIFRecord(ArrayList<StringBuilder> lineList, DuplicateValueBehavior duplicateValueBehavior, TrailingSpaceBehavior trailingSpaceBehavior, Schema schema, long firstLineNumber) {
            this.lineList = lineList;
            this.firstLineNumber = firstLineNumber;
            this.duplicateValueBehavior = duplicateValueBehavior;
            this.trailingSpaceBehavior = trailingSpaceBehavior;
            this.schema = schema;
            this.failureCause = null;
            this.isEOF = firstLineNumber < 0L || lineList != null && lineList.isEmpty();
        }

        private UnparsedLDIFRecord(Exception failureCause) {
            this.failureCause = failureCause;
            this.lineList = null;
            this.firstLineNumber = 0L;
            this.duplicateValueBehavior = DuplicateValueBehavior.REJECT;
            this.trailingSpaceBehavior = TrailingSpaceBehavior.REJECT;
            this.schema = null;
            this.isEOF = false;
        }

        private ArrayList<StringBuilder> getLineList() {
            return this.lineList;
        }

        private DuplicateValueBehavior getDuplicateValueBehavior() {
            return this.duplicateValueBehavior;
        }

        private TrailingSpaceBehavior getTrailingSpaceBehavior() {
            return this.trailingSpaceBehavior;
        }

        private Schema getSchema() {
            return this.schema;
        }

        private long getFirstLineNumber() {
            return this.firstLineNumber;
        }

        private boolean isEOF() {
            return this.isEOF;
        }

        private Exception getFailureCause() {
            return this.failureCause;
        }
    }
}

