/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthOktaScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.Base64Utils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthOktaRequest
extends AuthDefaultRequest {
    public AuthOktaRequest(AuthConfig config) {
        super(config, AuthDefaultSource.OKTA);
    }

    public AuthOktaRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.OKTA, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        String tokenUrl = this.accessTokenUrl(authCallback.getCode());
        return this.getAuthToken(tokenUrl);
    }

    private AuthToken getAuthToken(String tokenUrl) {
        HttpHeader header = new HttpHeader().add("accept", "application/json").add("content-type", "application/x-www-form-urlencoded").add("Authorization", "Basic " + Base64Utils.encode(this.config.getClientId().concat(":").concat(this.config.getClientSecret())));
        String response = new HttpUtils(this.config.getHttpConfig()).post(tokenUrl, null, header, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).tokenType(accessTokenObject.getString("token_type")).expireIn(accessTokenObject.getIntValue("expires_in")).scope(accessTokenObject.getString("scope")).refreshToken(accessTokenObject.getString("refresh_token")).idToken(accessTokenObject.getString("id_token")).build();
    }

    @Override
    public AuthResponse<AuthToken> refresh(AuthToken authToken) {
        if (null == authToken.getRefreshToken()) {
            return AuthResponse.builder().code(AuthResponseStatus.ILLEGAL_TOKEN.getCode()).msg(AuthResponseStatus.ILLEGAL_TOKEN.getMsg()).build();
        }
        String refreshUrl = this.refreshTokenUrl(authToken.getRefreshToken());
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(refreshUrl)).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        HttpHeader header = new HttpHeader().add("Authorization", "Bearer " + authToken.getAccessToken());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), null, header, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        JSONObject address = object.getJSONObject("address");
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("sub")).username(object.getString("name")).nickname(object.getString("nickname")).email(object.getString("email")).location(null == address ? null : address.getString("street_address")).gender(AuthUserGender.getRealGender(object.getString("sex"))).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse revoke(AuthToken authToken) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("token", authToken.getAccessToken());
        params.put("token_type_hint", "access_token");
        HttpHeader header = new HttpHeader().add("Authorization", "Basic " + Base64Utils.encode(this.config.getClientId().concat(":").concat(this.config.getClientSecret())));
        new HttpUtils(this.config.getHttpConfig()).post(this.revokeUrl(authToken), params, header, false);
        AuthResponseStatus status = AuthResponseStatus.SUCCESS;
        return AuthResponse.builder().code(status.getCode()).msg(status.getMsg()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.authorize(), this.config.getDomainPrefix(), this.config.getAuthServerId())).queryParam("response_type", "code").queryParam("prompt", "consent").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthOktaScope.values()))).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.accessToken(), this.config.getDomainPrefix(), this.config.getAuthServerId())).queryParam("code", code).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.refresh(), this.config.getDomainPrefix(), this.config.getAuthServerId())).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }

    @Override
    protected String revokeUrl(AuthToken authToken) {
        return String.format(this.source.revoke(), this.config.getDomainPrefix(), this.config.getAuthServerId());
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return String.format(this.source.userInfo(), this.config.getDomainPrefix(), this.config.getAuthServerId());
    }
}

