/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.convert;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.ConvertUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;

public class StringToEnumConverter
implements ConditionalGenericConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringToEnumConverter.class);
    private static final ConcurrentMap<Class<?>, AccessibleObject> ENUM_CACHE_MAP = new ConcurrentHashMap(8);

    @Nullable
    private static AccessibleObject getAnnotation(Class<?> clazz) {
        HashSet accessibleObjects = new HashSet();
        Constructor<?>[] constructors = clazz.getConstructors();
        Collections.addAll(accessibleObjects, constructors);
        Method[] methods = clazz.getDeclaredMethods();
        Collections.addAll(accessibleObjects, methods);
        for (AccessibleObject accessibleObject : accessibleObjects) {
            JsonCreator jsonCreator = accessibleObject.getAnnotation(JsonCreator.class);
            if (jsonCreator == null || JsonCreator.Mode.DISABLED == jsonCreator.mode()) continue;
            accessibleObject.setAccessible(true);
            return accessibleObject;
        }
        return null;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return true;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Enum.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (StringUtil.isBlank((String)source)) {
            return null;
        }
        Class clazz = targetType.getType();
        AccessibleObject accessibleObject = CollectionUtil.computeIfAbsent(ENUM_CACHE_MAP, clazz, StringToEnumConverter::getAnnotation);
        String value = ((String)source).trim();
        if (accessibleObject == null) {
            return StringToEnumConverter.valueOf(clazz, value);
        }
        try {
            return StringToEnumConverter.invoke(clazz, accessibleObject, value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static <T extends Enum<T>> T valueOf(Class<?> clazz, String value) {
        return (T)Enum.valueOf(clazz, value);
    }

    @Nullable
    private static Object invoke(Class<?> clazz, AccessibleObject accessibleObject, String value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (accessibleObject instanceof Constructor) {
            Constructor constructor = (Constructor)accessibleObject;
            Class<?> paramType = constructor.getParameterTypes()[0];
            Object object = ConvertUtil.convert((Object)value, paramType);
            return constructor.newInstance(object);
        }
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            Class<?> paramType = method.getParameterTypes()[0];
            Object object = ConvertUtil.convert((Object)value, paramType);
            return method.invoke(clazz, object);
        }
        return null;
    }
}

