/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.PortUnificationServer;

public class PortUnificationExchanger {
    private static final Logger log = LoggerFactory.getLogger(PortUnificationExchanger.class);
    private static final ConcurrentMap<String, PortUnificationServer> servers = new ConcurrentHashMap<String, PortUnificationServer>();

    public static void bind(URL url) {
        servers.computeIfAbsent(url.getAddress(), addr -> {
            PortUnificationServer server = new PortUnificationServer(url);
            server.bind();
            return server;
        });
    }

    public static void close() {
        ArrayList toClose = new ArrayList(servers.values());
        servers.clear();
        for (PortUnificationServer server : toClose) {
            try {
                server.close();
            }
            catch (Throwable throwable) {
                log.error("Close all port unification server failed", throwable);
            }
        }
    }

    public static ConcurrentMap<String, PortUnificationServer> getServers() {
        return servers;
    }
}

