/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.MailboxExecutor;

/**
 * A factory for creating processing time services with a given {@link MailboxExecutor}. The factory
 * is usually bound to a specific task.
 */
@FunctionalInterface
@Internal
public interface ProcessingTimeServiceFactory {

    /**
     * Creates a new processing time service with the mailbox executor. The mailbox executor is used
     * to defer the {@link ProcessingTimeCallback} of the timer registered with the {@link
     * ProcessingTimeService} to mailbox for execution.
     */
    ProcessingTimeService createProcessingTimeService(MailboxExecutor mailboxExecutor);
}
