/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.header;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Message;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.pulsar.support.header.PulsarHeaderMapper;
import org.springframework.pulsar.support.header.PulsarHeaderMatcher;

public abstract class AbstractPulsarHeaderMapper<ToPulsarHeadersContextType, ToSpringHeadersContextType>
implements PulsarHeaderMapper {
    private static final PulsarHeaderMatcher.PatternMatch EXCLUDE_PATTERN_ID = PulsarHeaderMatcher.PatternMatch.fromPatternString("!id");
    private static final PulsarHeaderMatcher.PatternMatch EXCLUDE_PATTERN_TIMESTAMP = PulsarHeaderMatcher.PatternMatch.fromPatternString("!timestamp");
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final List<PulsarHeaderMatcher> inboundMatchers = new ArrayList<PulsarHeaderMatcher>();
    private final List<PulsarHeaderMatcher> outboundMatchers = new ArrayList<PulsarHeaderMatcher>();

    public AbstractPulsarHeaderMapper(List<String> inboundPatterns, List<String> outboundPatterns) {
        Objects.requireNonNull(inboundPatterns, "inboundPatterns must be specified");
        Objects.requireNonNull(outboundPatterns, "outboundPatterns must be specified");
        inboundPatterns.forEach(p -> this.inboundMatchers.add(PulsarHeaderMatcher.PatternMatch.fromPatternString(p)));
        this.outboundMatchers.add(new PulsarHeaderMatcher.NeverMatch("pulsar_message_key", "pulsar_message_key_bytes", "pulsar_message_ordering_key", "pulsar_message_index", "pulsar_message_id", "pulsar_message_broker_publish_time", "pulsar_message_event_time", "pulsar_message_size", "pulsar_message_producer_name", "pulsar_message_raw_data", "pulsar_message_publish_time", "pulsar_message_redelivery_count", "pulsar_message_replicated_from", "pulsar_message_schema_version", "pulsar_message_sequence_id", "pulsar_message_topic_name"));
        if (outboundPatterns.isEmpty()) {
            this.outboundMatchers.add(EXCLUDE_PATTERN_ID);
            this.outboundMatchers.add(EXCLUDE_PATTERN_TIMESTAMP);
            this.outboundMatchers.add(PulsarHeaderMatcher.PatternMatch.fromPatternString("*"));
        } else {
            outboundPatterns.forEach(p -> this.outboundMatchers.add(PulsarHeaderMatcher.PatternMatch.fromPatternString(p)));
            this.outboundMatchers.add(EXCLUDE_PATTERN_ID);
            this.outboundMatchers.add(EXCLUDE_PATTERN_TIMESTAMP);
        }
    }

    @Override
    public Map<String, String> toPulsarHeaders(MessageHeaders springHeaders) {
        Objects.requireNonNull(springHeaders, "springHeaders must not be null");
        LinkedHashMap<String, String> pulsarHeaders = new LinkedHashMap<String, String>();
        ToPulsarHeadersContextType context = this.toPulsarHeadersOnStarted(springHeaders);
        springHeaders.forEach((key, rawValue) -> {
            if (this.matchesForOutbound((String)key)) {
                String value = this.toPulsarHeaderValue((String)key, rawValue, context);
                pulsarHeaders.put((String)key, value);
            }
        });
        this.toPulsarHeadersOnCompleted(springHeaders, pulsarHeaders, context);
        return pulsarHeaders;
    }

    @Nullable
    protected ToPulsarHeadersContextType toPulsarHeadersOnStarted(MessageHeaders springHeaders) {
        return null;
    }

    protected abstract String toPulsarHeaderValue(String var1, Object var2, @Nullable ToPulsarHeadersContextType var3);

    protected void toPulsarHeadersOnCompleted(MessageHeaders springHeaders, Map<String, String> pulsarHeaders, @Nullable ToPulsarHeadersContextType context) {
    }

    @Override
    public MessageHeaders toSpringHeaders(Message<?> pulsarMessage) {
        Objects.requireNonNull(pulsarMessage, "pulsarMessage must not be null");
        ToSpringHeadersContextType context = this.toSpringHeadersOnStarted(pulsarMessage);
        LinkedHashMap headersMap = new LinkedHashMap();
        pulsarMessage.getProperties().forEach((name, value) -> {
            if (this.matchesForInbound((String)name)) {
                Object valueToUse = this.toSpringHeaderValue((String)name, (String)value, context);
                headersMap.put(name, valueToUse);
            }
        });
        if (pulsarMessage.hasKey()) {
            this.addToHeadersMapIfAllowed("pulsar_message_key", () -> pulsarMessage.getKey(), headersMap::put);
            this.addToHeadersMapIfAllowed("pulsar_message_key_bytes", () -> pulsarMessage.getKeyBytes(), headersMap::put);
        }
        if (pulsarMessage.hasOrderingKey()) {
            this.addToHeadersMapIfAllowed("pulsar_message_ordering_key", () -> pulsarMessage.getOrderingKey(), headersMap::put);
        }
        if (pulsarMessage.hasIndex()) {
            this.addToHeadersMapIfAllowed("pulsar_message_index", () -> pulsarMessage.getIndex(), headersMap::put);
        }
        this.addToHeadersMapIfAllowed("pulsar_message_id", () -> pulsarMessage.getMessageId(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_broker_publish_time", () -> pulsarMessage.getBrokerPublishTime(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_event_time", () -> pulsarMessage.getEventTime(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_size", () -> pulsarMessage.size(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_producer_name", () -> pulsarMessage.getProducerName(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_raw_data", () -> pulsarMessage.getData(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_publish_time", () -> pulsarMessage.getPublishTime(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_redelivery_count", () -> pulsarMessage.getRedeliveryCount(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_replicated_from", () -> pulsarMessage.getReplicatedFrom(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_schema_version", () -> pulsarMessage.getSchemaVersion(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_sequence_id", () -> pulsarMessage.getSequenceId(), headersMap::put);
        this.addToHeadersMapIfAllowed("pulsar_message_topic_name", () -> pulsarMessage.getTopicName(), headersMap::put);
        MessageHeaders springHeaders = new MessageHeaders(headersMap);
        this.toSpringHeadersOnCompleted(pulsarMessage, springHeaders, context);
        return springHeaders;
    }

    @Nullable
    protected ToSpringHeadersContextType toSpringHeadersOnStarted(Message<?> pulsarMessage) {
        return null;
    }

    protected abstract Object toSpringHeaderValue(String var1, String var2, @Nullable ToSpringHeadersContextType var3);

    protected void toSpringHeadersOnCompleted(Message<?> pulsarMessage, MessageHeaders springHeaders, @Nullable ToSpringHeadersContextType context) {
    }

    protected boolean matchesForOutbound(String header) {
        if (this.outboundMatchers.isEmpty()) {
            return true;
        }
        return this.matchesAny(header, this.outboundMatchers);
    }

    protected boolean matchesForInbound(String header) {
        if (this.inboundMatchers.isEmpty()) {
            return true;
        }
        return this.matchesAny(header, this.inboundMatchers);
    }

    private boolean matchesAny(String header, List<PulsarHeaderMatcher> matchers) {
        for (PulsarHeaderMatcher matcher : matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        this.logger.debug(() -> "header (%s) WILL NOT be mapped; matched no patterns".formatted(header));
        return false;
    }

    private void addToHeadersMapIfAllowed(String key, Supplier<Object> valueSupplier, BiConsumer<String, Object> mapConsumer) {
        if (this.matchesForInbound(key)) {
            mapConsumer.accept(key, valueSupplier.get());
        }
    }
}

