/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.aop.MethodResultAutoOperateSupport;
import cn.crane4j.extension.spring.aop.AutoOperatePointcut;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class MethodResultAutoOperateAdvisor
implements PointcutAdvisor,
MethodInterceptor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateAdvisor.class);
    private final ObjectProvider<MethodResultAutoOperateSupport> methodResultAutoOperateSupport;
    private final Pointcut pointcut = AutoOperatePointcut.forAnnotatedMethod((m, c) -> !Objects.equals(m.getReturnType(), Void.TYPE) && AnnotatedElementUtils.isAnnotated((AnnotatedElement)m, AutoOperate.class));

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object result = methodInvocation.proceed();
        try {
            ((MethodResultAutoOperateSupport)this.methodResultAutoOperateSupport.getObject()).afterMethodInvoke(method, result, methodInvocation.getArguments());
        }
        catch (Exception ex) {
            log.error("cannot auto operate result for method [{}]", (Object)method, (Object)ex);
        }
        return result;
    }

    public @NonNull Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return false;
    }

    public void destroy() {
        this.methodResultAutoOperateSupport.ifAvailable(MethodResultAutoOperateSupport::destroy);
    }

    public ObjectProvider<MethodResultAutoOperateSupport> getMethodResultAutoOperateSupport() {
        return this.methodResultAutoOperateSupport;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public MethodResultAutoOperateAdvisor(ObjectProvider<MethodResultAutoOperateSupport> methodResultAutoOperateSupport) {
        this.methodResultAutoOperateSupport = methodResultAutoOperateSupport;
    }
}

