/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BroadcastTaskGenerator
extends AbstractJobTaskGenerator {
    private static final String TASK_NAME = "BROADCAST_TASK";
    private final JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.BROADCAST;
    }

    @Override
    @Transactional
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        Set serverNodes = CacheRegisterTable.getServerNodeSet((String)context.getGroupName(), (String)context.getNamespaceId());
        if (CollUtil.isEmpty((Collection)serverNodes)) {
            SnailJobLog.LOCAL.error("No executable client information. Job ID:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        HashSet<String> clientInfoSet = new HashSet<String>(serverNodes.size());
        ArrayList<JobTask> jobTasks = new ArrayList<JobTask>(serverNodes.size());
        for (RegisterNodeInfo serverNode : serverNodes) {
            String address = serverNode.address();
            if (clientInfoSet.contains(address)) continue;
            JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
            jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)serverNode));
            JobArgsHolder jobArgsHolder = new JobArgsHolder();
            jobArgsHolder.setJobParams((Object)context.getArgsStr());
            jobTask.setArgsStr(JsonUtil.toJsonString((Object)jobArgsHolder));
            jobTask.setArgsType(context.getArgsType());
            jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
            jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
            jobTask.setParentId(Long.valueOf(0L));
            jobTask.setLeaf(StatusEnum.YES.getStatus());
            jobTask.setRetryCount(Integer.valueOf(0));
            jobTask.setTaskName(TASK_NAME);
            jobTask.setCreateDt(LocalDateTime.now());
            jobTask.setUpdateDt(LocalDateTime.now());
            clientInfoSet.add(address);
            jobTasks.add(jobTask);
        }
        this.batchSaveJobTasks(jobTasks);
        return jobTasks;
    }

    @Generated
    public BroadcastTaskGenerator(JobTaskMapper jobTaskMapper) {
        this.jobTaskMapper = jobTaskMapper;
    }
}

