/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.enums.RetryTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RequestCallbackExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RequestRetryExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskExecuteDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailAlarmEvent;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimeoutCheckTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SceneConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RetryExecutorActor")
@Scope(value="prototype")
public class RetryExecutor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryExecutor.class);
    private final RetryMapper retryMapper;
    private final RetryTaskMapper retryTaskMapper;
    private final SceneConfigMapper sceneConfigMapper;
    private final ClientNodeAllocateHandler clientNodeAllocateHandler;
    private final RetryTaskStopHandler retryTaskStopHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryTaskExecuteDTO.class, execute -> {
            try {
                Assert.notNull((Object)execute.getRetryId(), () -> new SnailJobServerException("retryId can not be null"));
                Assert.notNull((Object)execute.getRetryTaskId(), () -> new SnailJobServerException("retryTaskId can not be null"));
                this.doExecute((RetryTaskExecuteDTO)execute);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Data scanner processing exception. [{}]", new Object[]{execute, e});
                this.updateRetryTaskStatus(execute.getRetryTaskId(), RetryTaskStatusEnum.FAIL.getStatus(), RetryOperationReasonEnum.TASK_EXECUTION_ERROR);
            }
        }).build();
    }

    private void doExecute(RetryTaskExecuteDTO execute) {
        Retry retry;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Retry::getId, (Object)execute.getRetryId());
        if (RetryTaskExecutorSceneEnum.MANUAL_RETRY.getScene() != execute.getRetryTaskExecutorScene().intValue()) {
            wrapper.eq(Retry::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus());
        }
        if (Objects.isNull(retry = (Retry)this.retryMapper.selectOne((Wrapper)wrapper))) {
            this.updateRetryTaskStatus(execute.getRetryTaskId(), RetryTaskStatusEnum.CANCEL.getStatus(), RetryOperationReasonEnum.NOT_RUNNING_RETRY);
            return;
        }
        execute.setNamespaceId(retry.getNamespaceId());
        execute.setGroupName(retry.getGroupName());
        execute.setTaskType(retry.getTaskType());
        if (CollUtil.isEmpty((Collection)CacheRegisterTable.getServerNodeSet((String)retry.getGroupName(), (String)retry.getNamespaceId()))) {
            this.updateRetryTaskStatus(execute.getRetryTaskId(), RetryTaskStatusEnum.CANCEL.getStatus(), RetryOperationReasonEnum.NOT_CLIENT);
            RetryTaskFailAlarmEventDTO toRetryTaskFailAlarmEventDTO = RetryTaskConverter.INSTANCE.toRetryTaskFailAlarmEventDTO(retry, "No client nodes", RetryNotifySceneEnum.RETRY_NO_CLIENT_NODES_ERROR.getNotifyScene());
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new RetryTaskFailAlarmEvent(toRetryTaskFailAlarmEventDTO));
            return;
        }
        RetrySceneConfig retrySceneConfig = (RetrySceneConfig)this.sceneConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getSceneName, (Object)retry.getSceneName())).eq(RetrySceneConfig::getGroupName, (Object)retry.getGroupName())).eq(RetrySceneConfig::getNamespaceId, (Object)retry.getNamespaceId()));
        if (StatusEnum.NO.getStatus().equals(retrySceneConfig.getSceneStatus())) {
            this.updateRetryTaskStatus(execute.getRetryTaskId(), RetryTaskStatusEnum.CANCEL.getStatus(), RetryOperationReasonEnum.SCENE_CLOSED);
            return;
        }
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(retry.getId().toString(), retry.getGroupName(), retry.getNamespaceId(), retrySceneConfig.getRouteKey());
        this.updateRetryTaskStatus(execute.getRetryTaskId(), RetryTaskStatusEnum.RUNNING.getStatus(), ClientInfoUtils.generate((RegisterNodeInfo)serverNode));
        if (SyetemTaskTypeEnum.CALLBACK.getType().equals(retry.getTaskType())) {
            RequestCallbackExecutorDTO callbackExecutorDTO = RetryTaskConverter.INSTANCE.toRequestCallbackExecutorDTO(retrySceneConfig, retry);
            callbackExecutorDTO.setClientId(serverNode.getHostId());
            callbackExecutorDTO.setRetryTaskId(execute.getRetryTaskId());
            ActorRef actorRef = ActorGenerator.callbackRealTaskExecutorActor();
            actorRef.tell((Object)callbackExecutorDTO, actorRef);
        } else {
            RequestRetryExecutorDTO retryExecutorDTO = RetryTaskConverter.INSTANCE.toRealRetryExecutorDTO(retrySceneConfig, retry);
            retryExecutorDTO.setClientId(serverNode.getHostId());
            retryExecutorDTO.setRetryTaskId(execute.getRetryTaskId());
            ActorRef actorRef = ActorGenerator.retryRealTaskExecutorActor();
            actorRef.tell((Object)retryExecutorDTO, actorRef);
        }
        RetryTimerWheel.registerWithRetry(() -> new RetryTimeoutCheckTask(execute.getRetryTaskId(), execute.getRetryId(), this.retryTaskStopHandler, this.retryMapper, this.retryTaskMapper), Duration.ofMillis(DateUtils.toEpochMilli((long)retrySceneConfig.getExecutorTimeout().intValue()) + 500L));
    }

    private void updateRetryTaskStatus(Long retryTaskId, Integer taskStatus, String clientInfo) {
        this.updateRetryTaskStatus(retryTaskId, taskStatus, RetryOperationReasonEnum.NONE, clientInfo);
    }

    private void updateRetryTaskStatus(Long retryTaskId, Integer taskStatus, RetryOperationReasonEnum reasonEnum) {
        this.updateRetryTaskStatus(retryTaskId, taskStatus, reasonEnum, null);
    }

    private void updateRetryTaskStatus(Long retryTaskId, Integer taskStatus, RetryOperationReasonEnum reasonEnum, String clientInfo) {
        RetryTask retryTask = new RetryTask();
        retryTask.setId(retryTaskId);
        retryTask.setTaskStatus(taskStatus);
        retryTask.setOperationReason(Integer.valueOf(reasonEnum.getReason()));
        retryTask.setClientInfo(clientInfo);
        this.retryTaskMapper.updateById((Object)retryTask);
    }

    @Generated
    public RetryExecutor(RetryMapper retryMapper, RetryTaskMapper retryTaskMapper, SceneConfigMapper sceneConfigMapper, ClientNodeAllocateHandler clientNodeAllocateHandler, RetryTaskStopHandler retryTaskStopHandler) {
        this.retryMapper = retryMapper;
        this.retryTaskMapper = retryTaskMapper;
        this.sceneConfigMapper = sceneConfigMapper;
        this.clientNodeAllocateHandler = clientNodeAllocateHandler;
        this.retryTaskStopHandler = retryTaskStopHandler;
    }
}

