/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.autoconfigure.condition;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class VelocityLayoutCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        return this.getMatchOutcome(environment);
    }

    protected ConditionOutcome getMatchOutcome(Environment environment) {
        boolean velocityEnabled = (Boolean)environment.getProperty("spring.velocity.enabled", Boolean.TYPE, (Object)true);
        if (!velocityEnabled) {
            return ConditionOutcome.noMatch((String)"The velocity layout is disabled , caused by spring.velocity.enabled = false");
        }
        boolean velocityLayoutEnabled = (Boolean)environment.getProperty("spring.velocity.layout-enabled", Boolean.TYPE, (Object)true);
        if (!velocityLayoutEnabled) {
            return ConditionOutcome.noMatch((String)"The velocity layout is disabled , caused by spring.velocity.layout-enabled = false");
        }
        return ConditionOutcome.match((String)"The velocity layout is enabled !");
    }
}

