/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.tools;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.springframework.util.Assert;

class FactoryConfigurationLoader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ServletContext servletContext;

    FactoryConfigurationLoader(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public FactoryConfiguration load(String ... toolboxConfigLocations) {
        FactoryConfiguration allFactoryConfiguration = new FactoryConfiguration();
        for (String toolboxConfigLocation : toolboxConfigLocations) {
            FactoryConfiguration factoryConfiguration = this.load(toolboxConfigLocation);
            if (factoryConfiguration == null) continue;
            allFactoryConfiguration.addConfiguration(factoryConfiguration);
        }
        return allFactoryConfiguration;
    }

    public FactoryConfiguration load(String toolboxConfigLocation) {
        Assert.notNull((Object)toolboxConfigLocation, (String)"The location of toolbox configuration must not be null");
        String location = this.normalize(toolboxConfigLocation);
        FactoryConfiguration factoryConfiguration = this.loadFromServletContext(this.servletContext, location);
        if (factoryConfiguration == null) {
            factoryConfiguration = this.loadFromClassPath(location);
        }
        return factoryConfiguration;
    }

    private String normalize(String toolboxConfigLocation) {
        String location = toolboxConfigLocation;
        if (location.startsWith("classpath:")) {
            location = location.substring("classpath:".length());
        }
        location = location.startsWith("/") ? location : "/" + location;
        return location;
    }

    private FactoryConfiguration loadFromServletContext(ServletContext servletContext, String contextPath) {
        String realPath = servletContext.getRealPath(contextPath);
        FactoryConfiguration factoryConfiguration = ConfigurationUtils.findInFileSystem((String)realPath);
        if (this.logger.isInfoEnabled()) {
            String message = "To find Toolbox Configuration[ context path : " + contextPath + " ] under Servlet Context[ path : " + realPath + "] , result : " + (factoryConfiguration != null ? "found !" : "not found !");
            this.logger.info((Object)message);
        }
        return factoryConfiguration;
    }

    private FactoryConfiguration loadFromClassPath(String location) {
        FactoryConfiguration factoryConfiguration = ConfigurationUtils.findInClasspath((String)location, (Object)this);
        if (this.logger.isInfoEnabled()) {
            String message = "The Toolbox Configuration can't be found In ServletContext , thus try to locate in classpath[" + location + "], result : " + (factoryConfiguration != null ? "found !" : "not found !");
            this.logger.info((Object)message);
        }
        return factoryConfiguration;
    }
}

