/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.plugins;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.plugins.IgnoreStrategy;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class InterceptorIgnoreHelper {
    private static final Map<String, IgnoreStrategy> IGNORE_STRATEGY_CACHE = new ConcurrentHashMap<String, IgnoreStrategy>();
    private static final ThreadLocal<IgnoreStrategy> IGNORE_STRATEGY_LOCAL = new ThreadLocal();

    public static void handle(IgnoreStrategy ignoreStrategy) {
        IGNORE_STRATEGY_LOCAL.set(ignoreStrategy);
    }

    public static void clearIgnoreStrategy() {
        IGNORE_STRATEGY_LOCAL.remove();
    }

    public static synchronized IgnoreStrategy initSqlParserInfoCache(Class<?> mapperClass) {
        InterceptorIgnore ignore = mapperClass.getAnnotation(InterceptorIgnore.class);
        if (ignore != null) {
            String key = mapperClass.getName();
            IgnoreStrategy cache = InterceptorIgnoreHelper.buildIgnoreStrategy(key, ignore);
            IGNORE_STRATEGY_CACHE.put(key, cache);
            return cache;
        }
        return null;
    }

    public static void initSqlParserInfoCache(IgnoreStrategy mapperAnnotation, String mapperClassName, Method method) {
        InterceptorIgnore ignoreStrategy = method.getAnnotation(InterceptorIgnore.class);
        String key = mapperClassName.concat(".").concat(method.getName());
        String name = mapperClassName.concat("#").concat(method.getName());
        if (ignoreStrategy != null) {
            IgnoreStrategy methodCache = InterceptorIgnoreHelper.buildIgnoreStrategy(name, ignoreStrategy);
            if (mapperAnnotation == null) {
                IGNORE_STRATEGY_CACHE.put(key, methodCache);
                return;
            }
            IGNORE_STRATEGY_CACHE.put(key, InterceptorIgnoreHelper.chooseCache(mapperAnnotation, methodCache));
        }
    }

    public static boolean willIgnoreTenantLine(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, IgnoreStrategy::getTenantLine);
    }

    public static boolean willIgnoreDynamicTableName(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, IgnoreStrategy::getDynamicTableName);
    }

    public static boolean willIgnoreBlockAttack(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, IgnoreStrategy::getBlockAttack);
    }

    public static boolean willIgnoreIllegalSql(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, IgnoreStrategy::getIllegalSql);
    }

    public static boolean willIgnoreDataPermission(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, IgnoreStrategy::getDataPermission);
    }

    public static boolean willIgnoreOthersByKey(String id, String key) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> CollectionUtils.isNotEmpty(i.getOthers()) && i.getOthers().getOrDefault(key, false) != false);
    }

    public static boolean willIgnore(String id, Function<IgnoreStrategy, Boolean> function) {
        IgnoreStrategy ignoreStrategy = IGNORE_STRATEGY_LOCAL.get();
        if (null == ignoreStrategy) {
            ignoreStrategy = IGNORE_STRATEGY_CACHE.get(id);
        }
        if (ignoreStrategy == null && id.endsWith("!selectKey")) {
            ignoreStrategy = IGNORE_STRATEGY_CACHE.get(id.substring(0, id.length() - "!selectKey".length()));
        }
        if (ignoreStrategy == null) {
            int index = id.lastIndexOf(".");
            ignoreStrategy = IGNORE_STRATEGY_CACHE.get(index > 0 ? id.substring(0, index) : id);
        }
        if (ignoreStrategy != null) {
            Boolean apply = function.apply(ignoreStrategy);
            return apply != null && apply != false;
        }
        return false;
    }

    private static IgnoreStrategy chooseCache(IgnoreStrategy mapper, IgnoreStrategy method) {
        return IgnoreStrategy.builder().tenantLine(InterceptorIgnoreHelper.chooseBoolean(mapper.getTenantLine(), method.getTenantLine())).dynamicTableName(InterceptorIgnoreHelper.chooseBoolean(mapper.getDynamicTableName(), method.getDynamicTableName())).blockAttack(InterceptorIgnoreHelper.chooseBoolean(mapper.getBlockAttack(), method.getBlockAttack())).illegalSql(InterceptorIgnoreHelper.chooseBoolean(mapper.getIllegalSql(), method.getIllegalSql())).dataPermission(InterceptorIgnoreHelper.chooseBoolean(mapper.getDataPermission(), method.getDataPermission())).others(InterceptorIgnoreHelper.chooseOthers(mapper.getOthers(), method.getOthers())).build();
    }

    private static IgnoreStrategy buildIgnoreStrategy(String name, InterceptorIgnore ignore) {
        return IgnoreStrategy.builder().tenantLine(InterceptorIgnoreHelper.getBoolean("tenantLine", name, ignore.tenantLine())).dynamicTableName(InterceptorIgnoreHelper.getBoolean("dynamicTableName", name, ignore.dynamicTableName())).blockAttack(InterceptorIgnoreHelper.getBoolean("blockAttack", name, ignore.blockAttack())).illegalSql(InterceptorIgnoreHelper.getBoolean("illegalSql", name, ignore.illegalSql())).dataPermission(InterceptorIgnoreHelper.getBoolean("dataPermission", name, ignore.dataPermission())).others(InterceptorIgnoreHelper.getOthers(name, ignore.others())).build();
    }

    private static Boolean getBoolean(String node, String name, String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if ("1".equals(value) || "true".equals(value) || "on".equals(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value) || "off".equals(value)) {
            return false;
        }
        throw ExceptionUtils.mpe("unsupported value \"%s\" by `@InterceptorIgnore#%s` on top of \"%s\"", value, node, name);
    }

    private static Map<String, Boolean> getOthers(String name, String[] values) {
        if (ArrayUtils.isEmpty(values)) {
            return null;
        }
        HashMap<String, Boolean> map = CollectionUtils.newHashMapWithExpectedSize(values.length);
        for (String s : values) {
            int index = s.indexOf("@");
            Assert.isTrue(index > 0, "unsupported value \"%s\" by `@InterceptorIgnore#others` on top of \"%s\"", s, name);
            String key = s.substring(0, index);
            Boolean value = InterceptorIgnoreHelper.getBoolean("others", name, s.substring(index + 1));
            map.put(key, value);
        }
        return map;
    }

    private static Boolean chooseBoolean(Boolean mapper, Boolean method) {
        if (mapper == null && method == null) {
            return null;
        }
        if (method != null) {
            return method;
        }
        return mapper;
    }

    private static Map<String, Boolean> chooseOthers(Map<String, Boolean> mapper, Map<String, Boolean> method) {
        boolean emptyMapper = CollectionUtils.isEmpty(mapper);
        boolean emptyMethod = CollectionUtils.isEmpty(method);
        if (emptyMapper && emptyMethod) {
            return null;
        }
        if (emptyMapper) {
            return method;
        }
        if (emptyMethod) {
            return mapper;
        }
        Set<String> mapperKeys = mapper.keySet();
        Set<String> methodKeys = method.keySet();
        HashSet<String> keys = new HashSet<String>(mapperKeys.size() + methodKeys.size());
        keys.addAll(methodKeys);
        keys.addAll(mapperKeys);
        HashMap<String, Boolean> map = CollectionUtils.newHashMapWithExpectedSize(keys.size());
        methodKeys.forEach(k -> map.put((String)k, InterceptorIgnoreHelper.chooseBoolean((Boolean)mapper.get(k), (Boolean)method.get(k))));
        return map;
    }
}

