/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.AbstractClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseStreamResponse;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpConnectionFactory;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

public class ClickHouseHttpClient
extends AbstractClient<ClickHouseHttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseHttpClient.class);

    protected boolean checkConnection(ClickHouseHttpConnection connection, ClickHouseNode requestServer, ClickHouseNode currentServer, ClickHouseRequest<?> request) {
        return connection != null && connection.isReusable() && requestServer.equals((Object)currentServer);
    }

    protected ClickHouseHttpConnection newConnection(ClickHouseHttpConnection connection, ClickHouseNode server, ClickHouseRequest<?> request) {
        if (connection != null && connection.isReusable()) {
            this.closeConnection(connection, false);
        }
        try {
            return ClickHouseHttpConnectionFactory.createConnection(server, request, this.getExecutor());
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    protected void closeConnection(ClickHouseHttpConnection connection, boolean force) {
        try {
            connection.close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to close http connection due to: %s", new Object[]{e.getMessage()});
        }
    }

    protected String buildQueryParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.append(ClickHouseHttpConnection.urlEncode(entry.getKey(), StandardCharsets.UTF_8)).append('=').append(ClickHouseHttpConnection.urlEncode(entry.getValue(), StandardCharsets.UTF_8)).append('&');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    protected ClickHouseResponse postRequest(ClickHouseRequest<?> sealedRequest) throws IOException {
        ClickHouseHttpConnection conn = (ClickHouseHttpConnection)this.getConnection(sealedRequest);
        List stmts = sealedRequest.getStatements(false);
        int size = stmts.size();
        if (size == 0) {
            throw new IllegalArgumentException("At least one SQL statement is required for execution");
        }
        if (size > 1) {
            throw new IllegalArgumentException("Expect one SQL statement to execute but we got " + size);
        }
        String sql = (String)stmts.get(0);
        log.debug((Object)"Query: %s", new Object[]{sql});
        ClickHouseHttpResponse httpResponse = conn.post(sql, sealedRequest.getInputStream().orElse(null), sealedRequest.getExternalTables(), null);
        return ClickHouseStreamResponse.of((ClickHouseConfig)httpResponse.getConfig(sealedRequest), (ClickHouseInputStream)httpResponse, (Map)sealedRequest.getSettings(), null, (ClickHouseResponseSummary)httpResponse.summary);
    }

    public boolean accept(ClickHouseProtocol protocol) {
        return ClickHouseProtocol.HTTP == protocol || super.accept(protocol);
    }

    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
        ClickHouseRequest sealedRequest = request.seal();
        if (sealedRequest.getConfig().isAsync()) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.postRequest(sealedRequest);
                }
                catch (IOException e) {
                    throw new CompletionException((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)sealedRequest.getServer()));
                }
            }, this.getExecutor());
        }
        try {
            return CompletableFuture.completedFuture(this.postRequest(sealedRequest));
        }
        catch (IOException e) {
            return this.failedResponse((Throwable)ClickHouseException.of((Throwable)e, (ClickHouseNode)sealedRequest.getServer()));
        }
    }

    public final Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseHttpOption.class;
    }

    public boolean ping(ClickHouseNode server, int timeout) {
        if (server != null) {
            return ((ClickHouseHttpConnection)this.getConnection(this.connect((Function)server))).ping(timeout);
        }
        return false;
    }
}

