/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.dataset;

import com.coze.openapi.api.DatasetAPI;
import com.coze.openapi.api.DatasetDocumentAPI;
import com.coze.openapi.api.DatasetImageAPI;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.dataset.CreateDatasetReq;
import com.coze.openapi.client.dataset.CreateDatasetResp;
import com.coze.openapi.client.dataset.DeleteDatasetReq;
import com.coze.openapi.client.dataset.DeleteDatasetResp;
import com.coze.openapi.client.dataset.ListDatasetReq;
import com.coze.openapi.client.dataset.ListDatasetResp;
import com.coze.openapi.client.dataset.ProcessDatasetReq;
import com.coze.openapi.client.dataset.ProcessDatasetResp;
import com.coze.openapi.client.dataset.UpdateDatasetReq;
import com.coze.openapi.client.dataset.UpdateDatasetResp;
import com.coze.openapi.client.dataset.model.Dataset;
import com.coze.openapi.service.service.dataset.DocumentService;
import com.coze.openapi.service.service.dataset.ImageService;
import com.coze.openapi.service.utils.Utils;

public class DatasetService {
    private final DatasetAPI api;
    private final DocumentService documentService;
    private final ImageService imageService;

    public DatasetService(DatasetAPI api, DatasetDocumentAPI documentApi, DatasetImageAPI imageApi) {
        this.api = api;
        this.documentService = new DocumentService(documentApi);
        this.imageService = new ImageService(imageApi);
    }

    public DocumentService documents() {
        return this.documentService;
    }

    public ImageService images() {
        return this.imageService;
    }

    public CreateDatasetResp create(CreateDatasetReq req) {
        return Utils.execute(this.api.create(req, req)).getData();
    }

    public PageResp<Dataset> list(ListDatasetReq req) {
        if (req.getSpaceID() == null) {
            throw new IllegalArgumentException("spaceID is required");
        }
        PageFetcher pageFetcher = request -> {
            ListDatasetResp resp = Utils.execute(this.api.list(req.getSpaceID(), req.getName(), req.getFormatType() != null ? req.getFormatType().getValue() : null, request.getPageSize(), request.getPageNum(), req)).getData();
            return PageResponse.builder().hasMore(resp.getDatasetList().size() == request.getPageSize().intValue()).data(resp.getDatasetList()).pageNum(request.getPageNum()).logID(resp.getLogID()).pageSize(request.getPageSize()).total(resp.getTotalCount()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, req.getPageSize());
        PageRequest initialRequest = PageRequest.builder().pageNum(req.getPageNum()).pageSize(req.getPageSize()).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().total(currentPage.getTotal()).items(currentPage.getData()).iterator(paginator).hasMore(currentPage.isHasMore()).logID(currentPage.getLogID()).build();
    }

    public UpdateDatasetResp update(UpdateDatasetReq req) {
        if (req.getDatasetID() == null) {
            throw new IllegalArgumentException("datasetID is required");
        }
        BaseResponse<UpdateDatasetResp> result = Utils.execute(this.api.update(req.getDatasetID(), req, req));
        return ((UpdateDatasetResp.UpdateDatasetRespBuilder)UpdateDatasetResp.builder().logID(result.getLogID())).build();
    }

    public DeleteDatasetResp delete(DeleteDatasetReq req) {
        BaseResponse<DeleteDatasetResp> result = Utils.execute(this.api.delete(req.getDatasetID(), req));
        return ((DeleteDatasetResp.DeleteDatasetRespBuilder)DeleteDatasetResp.builder().logID(result.getLogID())).build();
    }

    public ProcessDatasetResp process(ProcessDatasetReq req) {
        return Utils.execute(this.api.process(req.getDatasetID(), req, req)).getData();
    }
}

