package com.crazyxk.amountview;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

/**
 * @author Feng Chen
 */
public class AmountView extends LinearLayout {

    private int amount = 1;

    private EditText mEtAmount;
    private Button mBtnInc;
    private Button mBtnDec;

    private OnAmountChangeListener mListener;

    public AmountView(Context context) {
        this(context, null);
    }

    public AmountView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView(context, attrs);
    }

    public void setOnAmountChangeListener(OnAmountChangeListener listener) {
        mListener = listener;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        setValue();
    }

    public void changeAmount(int amount) {
        this.amount = amount;
        changeValue();
    }

    // SECTION : INNER HELPER

    private void initView(Context context, AttributeSet attrs) {
        initLayout(context);
        applyAttrs(context, attrs);
    }

    private void initLayout(Context context) {
        LayoutInflater.from(context).inflate(R.layout.layout_amount_view, this);
        mEtAmount = findViewById(R.id.et_amount);
        mBtnInc = findViewById(R.id.btn_inc);
        mBtnDec = findViewById(R.id.btn_dec);

        // 添加事件
        mEtAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty(s)) {
                    amount = 1;
                    changeAmount(amount);
                } else {
                    amount = Integer.parseInt(s.toString());
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        mBtnInc.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                amount++;
                mEtAmount.clearFocus();
                changeValue();
            }
        });

        mBtnDec.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (amount > 1) {
                    amount--;
                    mEtAmount.clearFocus();
                    changeValue();
                }
            }
        });
    }

    private void applyAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AmountView);
        int btnWidth = typedArray.getDimensionPixelSize(
                R.styleable.AmountView_btnWidth, LayoutParams.WRAP_CONTENT
        );
        int tvWidth = typedArray.getDimensionPixelSize(
                R.styleable.AmountView_tvWidth, 80
        );
        int btnTextSize = typedArray.getDimensionPixelSize(
                R.styleable.AmountView_btnTextSize, 0
        );
        int tvTextSize = typedArray.getDimensionPixelSize(
                R.styleable.AmountView_tvTextSize, 0
        );
        typedArray.recycle();

        LayoutParams btnParams = new LayoutParams(btnWidth, LayoutParams.MATCH_PARENT);
        mBtnInc.setLayoutParams(btnParams);
        mBtnDec.setLayoutParams(btnParams);

        if (btnTextSize != 0) {
            mBtnInc.setTextSize(TypedValue.COMPLEX_UNIT_PX, btnTextSize);
            mBtnDec.setTextSize(TypedValue.COMPLEX_UNIT_PX, btnTextSize);
        }

        LayoutParams textParams = new LayoutParams(tvWidth, LayoutParams.MATCH_PARENT);
        mEtAmount.setLayoutParams(textParams);
        if (tvTextSize != 0) {
            mEtAmount.setTextSize(tvTextSize);
        }

    }

    private void setValue() {
        mEtAmount.setText(String.valueOf(amount));
    }

    private void changeValue() {
        mEtAmount.setText(String.valueOf(amount));
        if (mListener != null) {
            mListener.onChange(amount);
        }
    }

    public interface OnAmountChangeListener {

        void onChange(int amount);

    }

}
