package com.crazyxk.pagingwindow.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Feng Chen
 */
public class Paging<T> {

    private List<Page> mPages = new ArrayList<>();

    private List<PageItem> mItems;
    private int mPageSize;

    public Paging(List<T> items, int pageSize) {
        convert(items);
        mPageSize = pageSize;
        paging();
    }

    public int getPageNum() {
        return mPages.size();
    }

    public Page getPage(int pageNo) {
        return mPages.get(pageNo);
    }

    public List<Page> getPages() {
        return mPages;
    }


    // SECTION : INNER HELPER

    private List<PageItem> convert(List<T> items) {
        mItems = new ArrayList<>();
        if (items != null && !items.isEmpty()) {
            for (int i = 0; i < items.size(); i++) {
                mItems.add(new PageItem(i, items.get(i)));
            }
        }
        return mItems;
    }

    private void paging() {

        for (int i = 0, n = 0; i < mItems.size(); i += mPageSize, n++) {
            mPages.add(new Page(
                    n,
                    mItems
                            .stream()
                            .skip(i)
                            .limit(mPageSize)
                            .collect(Collectors.<PageItem>toList()))
            );
        }

    }


}
