/*
 * Decompiled with CFR 0.152.
 */
package com.crazyxk.pagingwindow.bean;

import com.crazyxk.pagingwindow.bean.Page;
import com.crazyxk.pagingwindow.bean.PageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Paging<T> {
    private List<Page> mPages = new ArrayList<Page>();
    private List<PageItem> mItems;
    private int mPageSize;

    public Paging(List<T> items, int pageSize) {
        this.convert(items);
        this.mPageSize = pageSize;
        this.paging();
    }

    public int getPageNum() {
        return this.mPages.size();
    }

    public Page getPage(int pageNo) {
        return this.mPages.get(pageNo);
    }

    public List<Page> getPages() {
        return this.mPages;
    }

    private List<PageItem> convert(List<T> items) {
        this.mItems = new ArrayList<PageItem>();
        if (items != null && !items.isEmpty()) {
            for (int i = 0; i < items.size(); ++i) {
                this.mItems.add(new PageItem(i, items.get(i)));
            }
        }
        return this.mItems;
    }

    private void paging() {
        int i = 0;
        int n = 0;
        while (i < this.mItems.size()) {
            this.mPages.add(new Page(n, this.mItems.stream().skip(i).limit(this.mPageSize).collect(Collectors.toList())));
            i += this.mPageSize;
            ++n;
        }
    }
}

