/*
 * Decompiled with CFR 0.152.
 */
package com.crazyxk.pagingwindow.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.crazyxk.pagingwindow.R;
import com.crazyxk.pagingwindow.bean.ShapeHolder;
import java.util.ArrayList;
import java.util.List;

public class CircleIndicator
extends View {
    private ViewPager viewPager;
    private List<ShapeHolder> tabItems;
    private ShapeHolder movingItem;
    private int mCurItemPosition;
    private float mCurItemPositionOffset;
    private float mIndicatorRadius;
    private float mIndicatorMargin;
    private int mIndicatorBackground;
    private int mIndicatorSelectedBackground;
    private Gravity mIndicatorLayoutGravity;
    private Mode mIndicatorMode;
    private final int DEFAULT_INDICATOR_RADIUS = 10;
    private final int DEFAULT_INDICATOR_MARGIN = 40;
    private final int DEFAULT_INDICATOR_BACKGROUND = -16776961;
    private final int DEFAULT_INDICATOR_SELECTED_BACKGROUND = -65536;
    private final int DEFAULT_INDICATOR_LAYOUT_GRAVITY = Gravity.CENTER.ordinal();
    private final int DEFAULT_INDICATOR_MODE = Mode.SOLO.ordinal();

    public CircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.tabItems = new ArrayList<ShapeHolder>();
        this.handleTypedArray(context, attrs);
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicator);
        this.mIndicatorRadius = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_radius, 10);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_margin, 40);
        this.mIndicatorBackground = typedArray.getColor(R.styleable.CircleIndicator_ci_background, -16776961);
        this.mIndicatorSelectedBackground = typedArray.getColor(R.styleable.CircleIndicator_ci_selected_background, -65536);
        int gravity = typedArray.getInt(R.styleable.CircleIndicator_ci_gravity, this.DEFAULT_INDICATOR_LAYOUT_GRAVITY);
        this.mIndicatorLayoutGravity = Gravity.values()[gravity];
        int mode = typedArray.getInt(R.styleable.CircleIndicator_ci_mode, this.DEFAULT_INDICATOR_MODE);
        this.mIndicatorMode = Mode.values()[mode];
        typedArray.recycle();
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.createTabItems();
        this.createMovingItem();
        this.setUpListener();
    }

    private void setUpListener() {
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
                if (CircleIndicator.this.mIndicatorMode != Mode.SOLO) {
                    CircleIndicator.this.trigger(position, positionOffset);
                }
            }

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (CircleIndicator.this.mIndicatorMode == Mode.SOLO) {
                    CircleIndicator.this.trigger(position, 0.0f);
                }
            }
        });
    }

    private void trigger(int position, float positionOffset) {
        this.mCurItemPosition = position;
        this.mCurItemPositionOffset = positionOffset;
        this.requestLayout();
        this.invalidate();
    }

    private void createTabItems() {
        for (int i = 0; i < this.viewPager.getAdapter().getCount(); ++i) {
            OvalShape circle = new OvalShape();
            ShapeDrawable drawable = new ShapeDrawable((Shape)circle);
            ShapeHolder shapeHolder = new ShapeHolder(drawable);
            Paint paint = drawable.getPaint();
            paint.setColor(this.mIndicatorBackground);
            paint.setAntiAlias(true);
            shapeHolder.setPaint(paint);
            this.tabItems.add(shapeHolder);
        }
    }

    private void createMovingItem() {
        OvalShape circle = new OvalShape();
        ShapeDrawable drawable = new ShapeDrawable((Shape)circle);
        this.movingItem = new ShapeHolder(drawable);
        Paint paint = drawable.getPaint();
        paint.setColor(this.mIndicatorSelectedBackground);
        paint.setAntiAlias(true);
        switch (this.mIndicatorMode) {
            case INSIDE: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
                break;
            }
            case OUTSIDE: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
                break;
            }
            case SOLO: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
            }
        }
        this.movingItem.setPaint(paint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = this.getWidth();
        int height = this.getHeight();
        this.layoutTabItems(width, height);
        this.layoutMovingItem(this.mCurItemPosition, this.mCurItemPositionOffset);
    }

    private void layoutTabItems(int containerWidth, int containerHeight) {
        if (this.tabItems == null) {
            throw new IllegalStateException("forget to create tabItems?");
        }
        float yCoordinate = (float)containerHeight * 0.5f;
        float startPosition = this.startDrawPosition(containerWidth);
        for (int i = 0; i < this.tabItems.size(); ++i) {
            ShapeHolder item = this.tabItems.get(i);
            item.resizeShape(2.0f * this.mIndicatorRadius, 2.0f * this.mIndicatorRadius);
            item.setY(yCoordinate - this.mIndicatorRadius);
            float x = startPosition + (this.mIndicatorMargin + this.mIndicatorRadius * 2.0f) * (float)i;
            item.setX(x);
        }
    }

    private float startDrawPosition(int containerWidth) {
        if (this.mIndicatorLayoutGravity == Gravity.LEFT) {
            return 0.0f;
        }
        float tabItemsLength = (float)this.tabItems.size() * (2.0f * this.mIndicatorRadius + this.mIndicatorMargin) - this.mIndicatorMargin;
        if ((float)containerWidth < tabItemsLength) {
            return 0.0f;
        }
        if (this.mIndicatorLayoutGravity == Gravity.CENTER) {
            return ((float)containerWidth - tabItemsLength) / 2.0f;
        }
        return (float)containerWidth - tabItemsLength;
    }

    private void layoutMovingItem(int position, float positionOffset) {
        if (this.movingItem == null) {
            throw new IllegalStateException("forget to create movingItem?");
        }
        if (this.tabItems.size() == 0) {
            return;
        }
        ShapeHolder item = this.tabItems.get(position);
        this.movingItem.resizeShape(item.getWidth(), item.getHeight());
        float x = item.getX() + (this.mIndicatorMargin + this.mIndicatorRadius * 2.0f) * positionOffset;
        this.movingItem.setX(x);
        this.movingItem.setY(item.getY());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int sc = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        for (ShapeHolder item : this.tabItems) {
            this.drawItem(canvas, item);
        }
        if (this.movingItem != null) {
            this.drawItem(canvas, this.movingItem);
        }
        canvas.restoreToCount(sc);
    }

    private void drawItem(Canvas canvas, ShapeHolder shapeHolder) {
        canvas.save();
        canvas.translate(shapeHolder.getX(), shapeHolder.getY());
        shapeHolder.getShape().draw(canvas);
        canvas.restore();
    }

    public void setIndicatorRadius(float mIndicatorRadius) {
        this.mIndicatorRadius = mIndicatorRadius;
    }

    public void setIndicatorMargin(float mIndicatorMargin) {
        this.mIndicatorMargin = mIndicatorMargin;
    }

    public void setIndicatorBackground(int mIndicatorBackground) {
        this.mIndicatorBackground = mIndicatorBackground;
    }

    public void setIndicatorSelectedBackground(int mIndicatorSelectedBackground) {
        this.mIndicatorSelectedBackground = mIndicatorSelectedBackground;
    }

    public void setIndicatorLayoutGravity(Gravity mIndicatorLayoutGravity) {
        this.mIndicatorLayoutGravity = mIndicatorLayoutGravity;
    }

    public void setIndicatorMode(Mode mIndicatorMode) {
        this.mIndicatorMode = mIndicatorMode;
    }

    public static enum Mode {
        INSIDE,
        OUTSIDE,
        SOLO;

    }

    public static enum Gravity {
        LEFT,
        CENTER,
        RIGHT;

    }
}

