/*
 * Decompiled with CFR 0.152.
 */
package com.crazyxk.pagingwindow.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.crazyxk.pagingwindow.R;
import com.crazyxk.pagingwindow.bean.Page;
import com.crazyxk.pagingwindow.bean.PageItem;
import com.crazyxk.pagingwindow.bean.Paging;
import com.crazyxk.pagingwindow.view.CircleIndicator;
import java.util.ArrayList;
import java.util.List;

public class PagingWindow<T> {
    private Paging<T> mPaging;
    private ImageView mAction;
    private ViewPager mViewPager;
    private CircleIndicator mIndicator;
    private GridView mGridView;
    private Context mContext;
    private OnItemClickListener<T> mOnItemClickListener;
    private PopupWindow mWindow;
    private TitleGetter<T> mTitleGetter;
    private int mWidth;
    private int mHeight;
    private TextView last = null;

    public void setTitleGetter(TitleGetter<T> titleGetter) {
        this.mTitleGetter = titleGetter;
    }

    public void setOnItemClickListener(OnItemClickListener<T> listener) {
        this.mOnItemClickListener = listener;
    }

    public PagingWindow(Context context, int width, int height, List<T> items, int pageSize, TitleGetter<T> titleGetter, OnItemClickListener<T> onItemClickListener) {
        this.mContext = context;
        this.mPaging = new Paging<T>(items, pageSize);
        this.mWidth = width;
        this.mHeight = height;
        this.mTitleGetter = titleGetter;
        this.mOnItemClickListener = onItemClickListener;
        this.initView();
    }

    public void show() {
        if (this.mWindow != null && !this.mWindow.isShowing()) {
            View view = ((Activity)this.mContext).findViewById(0x1020002);
            this.mWindow.showAtLocation(view, 80, 0, 0);
        }
    }

    public void dismiss() {
        if (this.mWindow != null && this.mWindow.isShowing()) {
            this.mWindow.dismiss();
        }
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_paging_window, null);
        this.mAction = (ImageView)view.findViewById(R.id.paging_window_action);
        this.mViewPager = (ViewPager)view.findViewById(R.id.paging_window_viewpager);
        this.mIndicator = (CircleIndicator)view.findViewById(R.id.paging_window_indicator);
        this.initViewPager();
        this.mWindow = new PopupWindow(view, this.mWidth, this.mHeight);
        this.mWindow.setAnimationStyle(R.style.PagingWindow_Anim);
        this.mWindow.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.paging_window_bg, null));
        this.mAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PagingWindow.this.dismiss();
            }
        });
    }

    private void initViewPager() {
        ArrayList<View> views = new ArrayList<View>();
        for (int i = 0; i < this.mPaging.getPageNum(); ++i) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_paging_window_page, null);
            this.mGridView = (GridView)view.findViewById(R.id.paging_window_page_gridview);
            this.mGridView.setAdapter((ListAdapter)new GridViewAdapter(this.mContext, this.mPaging.getPage(i)));
            views.add(view);
        }
        this.mViewPager.setAdapter((PagerAdapter)new ViewPagerAdapter(views));
        this.mIndicator.setViewPager(this.mViewPager);
    }

    private class ViewHolder {
        TextView tvNo;
        TextView tvTitle;

        private ViewHolder() {
        }
    }

    private class GridViewAdapter
    extends BaseAdapter {
        private Context mContext;
        private Page mPage;

        public GridViewAdapter(Context context, Page page) {
            this.mContext = context;
            this.mPage = page;
        }

        public int getCount() {
            return this.mPage.getItems().size();
        }

        public Object getItem(int position) {
            return this.mPage.getItems().get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            final PageItem pageItem = this.mPage.getItems().get(position);
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_paging_window_page_item, null);
                viewHolder = new ViewHolder();
                viewHolder.tvNo = (TextView)convertView.findViewById(R.id.paging_window_page_item_no);
                viewHolder.tvTitle = (TextView)convertView.findViewById(R.id.paging_window_page_item_title);
                viewHolder.tvTitle.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (PagingWindow.this.last != null) {
                            PagingWindow.this.last.setTextColor(GridViewAdapter.this.mContext.getColor(R.color.gray));
                        }
                        ((TextView)v).setTextColor(GridViewAdapter.this.mContext.getColor(R.color.yellow));
                        if (PagingWindow.this.mOnItemClickListener != null) {
                            PagingWindow.this.mOnItemClickListener.onClick(pageItem.getIdx(), pageItem.getItem());
                        }
                        PagingWindow.this.last = (TextView)v;
                    }
                });
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            this.fillValue(pageItem, viewHolder);
            return convertView;
        }

        private void fillValue(PageItem pageItem, ViewHolder viewHolder) {
            viewHolder.tvNo.setText((CharSequence)(pageItem.getId() + "."));
            if (PagingWindow.this.mTitleGetter != null) {
                viewHolder.tvTitle.setText((CharSequence)PagingWindow.this.mTitleGetter.get(pageItem.getItem()));
            }
        }
    }

    public static class Builder<T> {
        private int mWidth;
        private int mHeight;
        private Context mContext;
        private TitleGetter mTitleGetter;
        private OnItemClickListener<T> mOnItemClickListener;
        private List<T> mItems;
        private int mPageSize;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setItems(List<T> items) {
            this.mItems = items;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.mPageSize = pageSize;
            return this;
        }

        public Builder setTitleGetter(TitleGetter<T> titleGetter) {
            this.mTitleGetter = titleGetter;
            return this;
        }

        public Builder setOnItemClickListener(OnItemClickListener<T> listener) {
            this.mOnItemClickListener = listener;
            return this;
        }

        public PagingWindow<T> build() {
            return new PagingWindow<T>(this.mContext, this.mWidth, this.mHeight, this.mItems, this.mPageSize, this.mTitleGetter, this.mOnItemClickListener);
        }
    }

    private class ViewPagerAdapter
    extends PagerAdapter {
        public List<View> mViewList;

        public ViewPagerAdapter(List<View> viewList) {
            this.mViewList = viewList;
        }

        public int getCount() {
            return this.mViewList.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View view = this.mViewList.get(position);
            container.addView(view);
            return view;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }
    }

    public static interface TitleGetter<T> {
        public String get(T var1);
    }

    public static interface OnItemClickListener<T> {
        public void onClick(int var1, T var2);
    }
}

