/*
 * Decompiled with CFR 0.152.
 */
package com.crazyxk.wheelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.crazyxk.wheelview.OnWheelChangedListener;
import com.crazyxk.wheelview.R;
import com.crazyxk.wheelview.WheelItem;
import com.crazyxk.wheelview.WheelScroller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WheelView
extends View {
    boolean mCyclic;
    int mItemCount;
    int mItemWidth;
    int mItemHeight;
    Rect mClipRectTop;
    Rect mClipRectMiddle;
    Rect mClipRectBottom;
    TextPaint mTextPaint;
    TextPaint mSelectedTextPaint;
    Paint mDividerPaint;
    Paint mHighlightPaint;
    WheelScroller mScroller;
    final List<WheelItem> mItems = new ArrayList<WheelItem>();

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelView);
        boolean cyclic = a.getBoolean(R.styleable.WheelView_wheelCyclic, false);
        int itemCount = a.getInt(R.styleable.WheelView_wheelItemCount, 9);
        int itemWidth = a.getDimensionPixelOffset(R.styleable.WheelView_wheelItemWidth, this.dp(R.dimen.wheel_item_width));
        int itemHeight = a.getDimensionPixelOffset(R.styleable.WheelView_wheelItemHeight, this.dp(R.dimen.wheel_item_height));
        int textSize = a.getDimensionPixelSize(R.styleable.WheelView_wheelTextSize, this.sp(R.dimen.wheel_text_size));
        int textColor = a.getColor(R.styleable.WheelView_wheelTextColor, this.color(R.color.wheel_text_color));
        int selectedTextColor = a.getColor(R.styleable.WheelView_wheelSelectedTextColor, this.color(R.color.wheel_selected_text_color));
        int dividerColor = a.getColor(R.styleable.WheelView_wheelDividerColor, this.color(R.color.wheel_divider_color));
        int highlightColor = a.getColor(R.styleable.WheelView_wheelHighlightColor, this.color(R.color.wheel_highlight_color));
        a.recycle();
        this.mCyclic = cyclic;
        this.mItemCount = itemCount;
        this.mItemWidth = itemWidth;
        this.mItemHeight = itemHeight;
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextPaint.setColor(textColor);
        this.mSelectedTextPaint = new TextPaint();
        this.mSelectedTextPaint.setAntiAlias(true);
        this.mSelectedTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedTextPaint.setTextSize((float)textSize);
        this.mSelectedTextPaint.setColor(selectedTextColor);
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setAntiAlias(true);
        this.mDividerPaint.setStrokeWidth((float)this.getResources().getDimensionPixelOffset(R.dimen.wheel_divider_height));
        this.mDividerPaint.setColor(dividerColor);
        this.mHighlightPaint = new Paint();
        this.mHighlightPaint.setAntiAlias(true);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(highlightColor);
        this.mScroller = new WheelScroller(context, this);
    }

    public int getPrefWidth() {
        int paddingHorizontal = this.getPaddingLeft() + this.getPaddingRight();
        return paddingHorizontal + this.mItemWidth;
    }

    public int getPrefHeight() {
        int paddingVertical = this.getPaddingTop() + this.getPaddingBottom();
        return paddingVertical + this.mItemHeight * this.mItemCount;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
            this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        } else if (widthSpecMode == 0x40000000) {
            this.setMeasuredDimension(widthSpecSize, this.getPrefHeight());
        } else if (heightSpecMode == 0x40000000) {
            this.setMeasuredDimension(this.getPrefWidth(), heightSpecSize);
        } else {
            this.setMeasuredDimension(this.getPrefWidth(), this.getPrefHeight());
        }
        this.updateClipRect();
    }

    private void updateClipRect() {
        int clipLeft = this.getPaddingLeft();
        int clipRight = this.getMeasuredWidth() - this.getPaddingRight();
        int clipTop = this.getPaddingTop();
        int clipBottom = this.getMeasuredHeight() - this.getPaddingBottom();
        int clipVMiddle = (clipTop + clipBottom) / 2;
        this.mClipRectMiddle = new Rect();
        this.mClipRectMiddle.left = clipLeft;
        this.mClipRectMiddle.right = clipRight;
        this.mClipRectMiddle.top = clipVMiddle - this.mItemHeight / 2;
        this.mClipRectMiddle.bottom = clipVMiddle + this.mItemHeight / 2;
        this.mClipRectTop = new Rect();
        this.mClipRectTop.left = clipLeft;
        this.mClipRectTop.right = clipRight;
        this.mClipRectTop.top = clipTop;
        this.mClipRectTop.bottom = clipVMiddle - this.mItemHeight / 2;
        this.mClipRectBottom = new Rect();
        this.mClipRectBottom.left = clipLeft;
        this.mClipRectBottom.right = clipRight;
        this.mClipRectBottom.top = clipVMiddle + this.mItemHeight / 2;
        this.mClipRectBottom.bottom = clipBottom;
    }

    protected void onDraw(Canvas canvas) {
        this.drawHighlight(canvas);
        this.drawItems(canvas);
        this.drawDivider(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mScroller.onTouchEvent(event);
    }

    public void computeScroll() {
        this.mScroller.computeScroll();
    }

    public boolean isCyclic() {
        return this.mCyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.mCyclic = cyclic;
        this.mScroller.reset();
        this.invalidate();
    }

    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    public void setTextSize(int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.mSelectedTextPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextPaint.getColor();
    }

    public void setTextColor(int color2) {
        this.mTextPaint.setColor(color2);
        this.invalidate();
    }

    public int getSelectedTextColor() {
        return this.mSelectedTextPaint.getColor();
    }

    public void setSelectedTextColor(int color2) {
        this.mSelectedTextPaint.setColor(color2);
        this.invalidate();
    }

    public int getItemSize() {
        return this.mItems.size();
    }

    public WheelItem getItem(int index) {
        if (index < 0 && index >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(index);
    }

    public WheelItem getCurrentItem() {
        return this.getItem(this.getCurrentIndex());
    }

    public int getCurrentIndex() {
        return this.mScroller.getCurrentIndex();
    }

    public void setCurrentIndex(int index) {
        this.setCurrentIndex(index, false);
    }

    public void setCurrentIndex(int index, boolean animated) {
        this.mScroller.setCurrentIndex(index, animated);
    }

    public void setItems(WheelItem ... items) {
        this.mItems.clear();
        if (items != null && items.length > 0) {
            Collections.addAll(this.mItems, items);
        }
        this.mScroller.reset();
        this.invalidate();
    }

    public void setItems(Collection<? extends WheelItem> items) {
        this.mItems.clear();
        if (items != null && items.size() > 0) {
            this.mItems.addAll(items);
        }
        this.mScroller.reset();
        this.invalidate();
    }

    public OnWheelChangedListener getOnWheelChangedListener() {
        return this.mScroller.onWheelChangedListener;
    }

    public void setOnWheelChangedListener(OnWheelChangedListener onWheelChangedListener) {
        this.mScroller.onWheelChangedListener = onWheelChangedListener;
    }

    private int dp(int resId) {
        return this.getResources().getDimensionPixelOffset(resId);
    }

    private int sp(int resId) {
        return this.getResources().getDimensionPixelSize(resId);
    }

    private int color(int resId) {
        return this.getResources().getColor(resId, null);
    }

    private void drawItems(Canvas canvas) {
        int maxIdx;
        int minIdx;
        int index = this.mScroller.getItemIndex();
        int offset = this.mScroller.getItemOffset();
        int hf = (this.mItemCount + 1) / 2;
        if (offset < 0) {
            minIdx = index - hf - 1;
            maxIdx = index + hf;
        } else if (offset > 0) {
            minIdx = index - hf;
            maxIdx = index + hf + 1;
        } else {
            minIdx = index - hf;
            maxIdx = index + hf;
        }
        for (int i = minIdx; i < maxIdx; ++i) {
            this.drawItem(canvas, i, offset);
        }
    }

    protected void drawItem(Canvas canvas, int index, int offset) {
        CharSequence text = this.getTitle(index);
        if (text == null) {
            return;
        }
        int centerX = this.mClipRectMiddle.centerX();
        int centerY = this.mClipRectMiddle.centerY();
        int range = (index - this.mScroller.getItemIndex()) * this.mItemHeight - offset;
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        int baseline = (int)((fontMetrics.top + fontMetrics.bottom) / 2.0f);
        if (range > 0 && range < this.mItemHeight) {
            canvas.save();
            canvas.clipRect(this.mClipRectMiddle);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mSelectedTextPaint);
            canvas.restore();
            canvas.save();
            canvas.clipRect(this.mClipRectBottom);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range >= this.mItemHeight) {
            canvas.save();
            canvas.clipRect(this.mClipRectBottom);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range < 0 && range > -this.mItemHeight) {
            canvas.save();
            canvas.clipRect(this.mClipRectMiddle);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mSelectedTextPaint);
            canvas.restore();
            canvas.save();
            canvas.clipRect(this.mClipRectTop);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mTextPaint);
            canvas.restore();
        } else if (range <= -this.mItemHeight) {
            canvas.save();
            canvas.clipRect(this.mClipRectTop);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mTextPaint);
            canvas.restore();
        } else {
            canvas.save();
            canvas.clipRect(this.mClipRectMiddle);
            canvas.drawText(text, 0, text.length(), (float)centerX, (float)(centerY + range - baseline), (Paint)this.mSelectedTextPaint);
            canvas.restore();
        }
    }

    private CharSequence getTitle(int index) {
        int size = this.mItems.size();
        if (size == 0) {
            return null;
        }
        String text = null;
        if (this.isCyclic()) {
            int i = index % size;
            if (i < 0) {
                i += size;
            }
            text = this.mItems.get(i).getTitle();
        } else if (index >= 0 && index < size) {
            text = this.mItems.get(index).getTitle();
        }
        return text;
    }

    private void drawHighlight(Canvas canvas) {
        canvas.drawRect(this.mClipRectMiddle, this.mHighlightPaint);
    }

    private void drawDivider(Canvas canvas) {
        canvas.drawLine((float)this.mClipRectMiddle.left, (float)this.mClipRectMiddle.top, (float)this.mClipRectMiddle.right, (float)this.mClipRectMiddle.top, this.mDividerPaint);
        canvas.drawLine((float)this.mClipRectMiddle.left, (float)this.mClipRectMiddle.bottom, (float)this.mClipRectMiddle.right, (float)this.mClipRectMiddle.bottom, this.mDividerPaint);
    }
}

