package com.cssw.afr.autoconfigure;

import com.cssw.afr.AfrNet;
import com.cssw.afr.core.AfrApi;
import com.cssw.afr.core.AfrApiImpl;
import com.cssw.afr.core.dao.AfrDao;
import com.cssw.afr.core.dao.AfrDaoImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import javax.annotation.PostConstruct;

/**
 * @author Feng Chen
 */
@Slf4j
@AutoConfiguration
@EnableConfigurationProperties(AfrProperties.class)
@ConditionalOnProperty(prefix = "cssw.afr", name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class AfrAutoConfiguration {

    private final AfrProperties afrProperties;

    @Bean
    @ConditionalOnMissingBean
    public AfrDao afrDao() {
        return new AfrDaoImpl(afrProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AfrApi afrApi(AfrDao afrDao) {
        return new AfrApiImpl(afrDao);
    }

    @PostConstruct
    public void postConstruct() {
        AfrNet.configure(
                afrProperties.getDetectorModelFilePath(),
                afrProperties.getLandmarkerModelFilePath(),
                afrProperties.getRecognizerModelFilePath()
        );
        log.debug(" Auto Configuration 'Afr' completed initialization.");
    }

}
