package com.cssw.afr.autoconfigure;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Feng Chen
 */
@Setter
@Getter
@ConfigurationProperties(prefix = "cssw.afr")
public class AfrProperties {

    /**
     * 是否启用
     */
    private boolean enabled = false;

    /**
     * 检测模型文件路径
     */
    private String detectorModelFilePath;

    /**
     * 特征模型文件路径
     */
    private String landmarkerModelFilePath;

    /**
     * 识别模型文件路径
     */
    private String recognizerModelFilePath;

    /**
     * 数据库名称
     */
    private String dbName = "afr";

    /**
     * 向量数据库连接地址 http://host:port, eg: http://localhost:19530
     */
    private String url;

    /**
     * 向量数据库用户
     */
    private String username;

    /**
     * 向量数据库密码
     */
    private String password;


}
