package com.cssw.afr.core;

import com.cssw.afr.core.model.req.*;
import com.cssw.afr.core.model.resp.DetectResp;
import com.cssw.afr.core.model.resp.SearchResp;

/**
 * @author Feng Chen
 */
public interface AfrApi {

    /**
     * 人脸检测
     *
     * @param req 人脸检测参数
     * @return 人脸检测结果
     */
    DetectResp detect(DetectReq req);

    /**
     * 人员库创建
     *
     * @param req 人员库创建请求
     */
    void createGroup(GroupCreateReq req);

    /**
     * 人员库删除
     *
     * @param req 人员库删除请求
     */
    void deleteGroup(GroupDeleteReq req);

    /**
     * 人员创建
     *
     * @param req 人员库创建请求
     */
    void createPerson(PersonCreateReq req);

    /**
     * 人员更新
     *
     * @param req 人员更新请求
     */
    void updatePerson(PersonUpdateReq req);

    /**
     * 人员删除
     *
     * @param req 人员删除请求
     */
    void deletePerson(PersonDeleteReq req);

    /**
     * 人员检索
     *
     * @param req 人员检索请求
     * @return 人员检索结果
     */
    SearchResp search(SearchReq req);

}
