package com.cssw.afr.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Feng Chen
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class GsonUtil {

    private static final Gson gson = new Gson();

    /**
     * 将对象转换为JsonObject集合
     *
     * @param objs 待转换对象集合
     * @return JsonObject集合
     */
    public static List<JsonObject> toJsonObjectList(Object... objs) {
        List<JsonObject> list = new ArrayList<>();
        for (Object obj : objs) {
            list.add(gson.toJsonTree(obj).getAsJsonObject());
        }
        return list;
    }

}
