/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.auth.satoken.autoconfigure.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.SaTokenDaoDefaultImpl;
import cn.dev33.satoken.dao.SaTokenDaoForRedisson;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;

public class SaTokenDaoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaTokenDaoConfiguration.class);

    @ConditionalOnProperty(name={"sa-token.extension.dao.type"}, havingValue="custom")
    public static class Custom {
        @Bean
        @ConditionalOnMissingBean
        public SaTokenDao saTokenDao() {
            if (log.isErrorEnabled()) {
                log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(SaTokenDao.class));
            }
            throw new NoSuchBeanDefinitionException(SaTokenDao.class);
        }
    }

    @ConditionalOnMissingBean(value={SaTokenDao.class})
    @AutoConfigureAfter(value={RedissonAutoConfiguration.class})
    @ConditionalOnProperty(name={"sa-token.extension.dao.type"}, havingValue="redis")
    public static class Redis {
        @Bean
        public SaTokenDao saTokenDao(RedissonClient redissonClient) {
            return new SaTokenDaoForRedisson(redissonClient);
        }

        static {
            log.debug("[Bootx Starter] - Auto Configuration 'SaToken-Dao-Redis' completed initialization.");
        }
    }

    @ConditionalOnMissingBean(value={SaTokenDao.class})
    @ConditionalOnProperty(name={"sa-token.extension.dao.type"}, havingValue="default", matchIfMissing=true)
    public static class Default {
        @Bean
        public SaTokenDao saTokenDao() {
            return new SaTokenDaoDefaultImpl();
        }

        static {
            log.debug("[Bootx Starter] - Auto Configuration 'SaToken-Dao-Default' completed initialization.");
        }
    }
}

