/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.cache.redisson.autoconfigure;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.cache.redisson.autoconfigure.RedissonProperties;
import com.cssw.bootx.cache.redisson.handler.NameMapperHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.redisson.api.NameMapper;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="spring.data.redisson", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedissonAutoConfiguration.class);
    private final RedissonProperties properties;
    private final RedisProperties redisProperties;
    private final ObjectMapper objectMapper;
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";

    public RedissonAutoConfiguration(RedissonProperties properties, RedisProperties redisProperties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.redisProperties = redisProperties;
        this.objectMapper = objectMapper;
    }

    @Bean
    public RedissonAutoConfigurationCustomizer redissonAutoConfigurationCustomizer() {
        return config -> {
            RedissonProperties.Mode mode = this.properties.getMode();
            String protocolPrefix = this.redisProperties.getSsl().isEnabled() ? REDISS_PROTOCOL_PREFIX : REDIS_PROTOCOL_PREFIX;
            switch (mode) {
                case CLUSTER: {
                    this.buildClusterModeConfig(config, protocolPrefix);
                    break;
                }
                case SENTINEL: {
                    this.buildSentinelModeConfig(config, protocolPrefix);
                    break;
                }
                default: {
                    this.buildSingleModeConfig(config, protocolPrefix);
                }
            }
            config.setCodec((Codec)new JsonJacksonCodec(this.objectMapper));
            log.debug("[Bootx Starter] - Auto Configuration 'Redisson' completed initialization.");
        };
    }

    private void buildClusterModeConfig(Config config, String protocolPrefix) {
        ClusterServersConfig clusterServersConfig = config.useClusterServers();
        ClusterServersConfig customClusterServersConfig = this.properties.getClusterServersConfig();
        if (customClusterServersConfig != null) {
            BeanUtil.copyProperties((Object)customClusterServersConfig, (Object)clusterServersConfig, (String[])new String[0]);
            clusterServersConfig.setNodeAddresses(customClusterServersConfig.getNodeAddresses());
        }
        if (CollUtil.isEmpty((Collection)clusterServersConfig.getNodeAddresses())) {
            List nodeList = this.redisProperties.getCluster().getNodes();
            nodeList.stream().map(node -> protocolPrefix + node).forEach(xva$0 -> clusterServersConfig.addNodeAddress(new String[]{xva$0}));
        }
        if (CharSequenceUtil.isBlank((CharSequence)clusterServersConfig.getPassword())) {
            String password = this.redisProperties.getPassword();
            clusterServersConfig.setPassword(CharSequenceUtil.isNotBlank((CharSequence)password) ? password : null);
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.properties.getKeyPrefix())) {
            clusterServersConfig.setNameMapper((NameMapper)new NameMapperHandler(this.properties.getKeyPrefix()));
        }
    }

    private void buildSentinelModeConfig(Config config, String protocolPrefix) {
        SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
        SentinelServersConfig customSentinelServersConfig = this.properties.getSentinelServersConfig();
        if (customSentinelServersConfig != null) {
            BeanUtil.copyProperties((Object)customSentinelServersConfig, (Object)sentinelServersConfig, (String[])new String[0]);
            sentinelServersConfig.setSentinelAddresses(customSentinelServersConfig.getSentinelAddresses());
        }
        if (CollUtil.isEmpty((Collection)sentinelServersConfig.getSentinelAddresses())) {
            List nodeList = this.redisProperties.getSentinel().getNodes();
            nodeList.stream().map(node -> protocolPrefix + node).forEach(xva$0 -> sentinelServersConfig.addSentinelAddress(new String[]{xva$0}));
        }
        if (CharSequenceUtil.isBlank((CharSequence)sentinelServersConfig.getPassword())) {
            String password = this.redisProperties.getPassword();
            sentinelServersConfig.setPassword(CharSequenceUtil.isNotBlank((CharSequence)password) ? password : null);
        }
        if (CharSequenceUtil.isBlank((CharSequence)sentinelServersConfig.getMasterName())) {
            sentinelServersConfig.setMasterName(this.redisProperties.getSentinel().getMaster());
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.properties.getKeyPrefix())) {
            sentinelServersConfig.setNameMapper((NameMapper)new NameMapperHandler(this.properties.getKeyPrefix()));
        }
    }

    private void buildSingleModeConfig(Config config, String protocolPrefix) {
        SingleServerConfig singleServerConfig = config.useSingleServer();
        SingleServerConfig customSingleServerConfig = this.properties.getSingleServerConfig();
        if (customSingleServerConfig != null) {
            BeanUtil.copyProperties((Object)this.properties.getSingleServerConfig(), (Object)singleServerConfig, (String[])new String[0]);
        }
        singleServerConfig.setDatabase(this.redisProperties.getDatabase());
        if (CharSequenceUtil.isBlank((CharSequence)singleServerConfig.getPassword())) {
            String password = this.redisProperties.getPassword();
            singleServerConfig.setPassword(CharSequenceUtil.isNotBlank((CharSequence)password) ? password : null);
        }
        if (CharSequenceUtil.isBlank((CharSequence)singleServerConfig.getAddress())) {
            singleServerConfig.setAddress(protocolPrefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort());
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.properties.getKeyPrefix())) {
            singleServerConfig.setNameMapper((NameMapper)new NameMapperHandler(this.properties.getKeyPrefix()));
        }
    }
}

