/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.api.autoconfigure;

import com.cssw.bootx.encrypt.api.autoconfigure.ApiEncryptProperties;
import com.cssw.bootx.encrypt.api.filter.ApiEncryptFilter;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={ApiEncryptProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.encrypt.api", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEncryptAutoConfiguration.class);

    @Bean
    public FilterRegistrationBean<ApiEncryptFilter> apiEncryptFilter(ApiEncryptProperties properties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ApiEncryptFilter(properties));
        registrationBean.setOrder(Integer.MIN_VALUE);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registrationBean;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Encrypt-API' completed initialization.");
    }
}

