/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.api.filter;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.cssw.bootx.core.util.SpringWebUtils;
import com.cssw.bootx.encrypt.api.annotation.ApiEncrypt;
import com.cssw.bootx.encrypt.api.autoconfigure.ApiEncryptProperties;
import com.cssw.bootx.encrypt.api.filter.RequestBodyDecryptWrapper;
import com.cssw.bootx.encrypt.api.filter.ResponseBodyEncryptWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpMethod;

public class ApiEncryptFilter
implements Filter {
    private final ApiEncryptProperties properties;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String secretKeyValue;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean isResponseEncrypt = this.isResponseEncrypt(request);
        String secretKeyHeader = this.properties.getSecretKeyHeader();
        RequestBodyDecryptWrapper requestWrapper = null;
        ResponseBodyEncryptWrapper responseWrapper = null;
        ResponseBodyEncryptWrapper responseBodyEncryptWrapper = null;
        if ((HttpMethod.PUT.matches(request.getMethod()) || HttpMethod.POST.matches(request.getMethod())) && CharSequenceUtil.isNotBlank((CharSequence)(secretKeyValue = request.getHeader(secretKeyHeader)))) {
            requestWrapper = new RequestBodyDecryptWrapper(request, this.properties.getPrivateKey(), secretKeyHeader);
        }
        if (isResponseEncrypt) {
            responseWrapper = responseBodyEncryptWrapper = new ResponseBodyEncryptWrapper(response);
        }
        chain.doFilter((ServletRequest)ObjectUtil.defaultIfNull(requestWrapper, (Object)request), (ServletResponse)ObjectUtil.defaultIfNull((Object)((Object)responseWrapper), (Object)response));
        if (isResponseEncrypt) {
            servletResponse.reset();
            String encryptContent = responseBodyEncryptWrapper.getEncryptContent(response, this.properties.getPublicKey(), secretKeyHeader);
            servletResponse.getWriter().write(encryptContent);
        }
    }

    private boolean isResponseEncrypt(HttpServletRequest request) {
        ApiEncrypt apiEncrypt = Optional.ofNullable(SpringWebUtils.getHandlerMethod((HttpServletRequest)request)).map(h -> (ApiEncrypt)h.getMethodAnnotation(ApiEncrypt.class)).orElse(null);
        return apiEncrypt != null && apiEncrypt.response();
    }

    @Generated
    public ApiEncryptFilter(ApiEncryptProperties properties) {
        this.properties = properties;
    }
}

