/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.api.filter;

import cn.hutool.core.io.IoUtil;
import com.cssw.bootx.encrypt.util.EncryptUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class RequestBodyDecryptWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public RequestBodyDecryptWrapper(HttpServletRequest request, String privateKey, String secretKeyHeader) throws IOException {
        super(request);
        this.body = this.getDecryptContent(request, privateKey, secretKeyHeader);
    }

    public byte[] getDecryptContent(HttpServletRequest request, String privateKey, String secretKeyHeader) throws IOException {
        String secretKeyByRsa = request.getHeader(secretKeyHeader);
        String secretKeyByBase64 = EncryptUtils.decryptByRsa((String)secretKeyByRsa, (String)privateKey);
        String aesSecretKey = EncryptUtils.decodeByBase64((String)secretKeyByBase64);
        request.setCharacterEncoding("UTF-8");
        byte[] readBytes = IoUtil.readBytes((InputStream)request.getInputStream(), (boolean)false);
        String requestBody = new String(readBytes, StandardCharsets.UTF_8);
        return EncryptUtils.decryptByAes((String)requestBody, (String)aesSecretKey).getBytes(StandardCharsets.UTF_8);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public int getContentLength() {
        return this.body.length;
    }

    public long getContentLengthLong() {
        return this.body.length;
    }

    public String getContentType() {
        return "application/json";
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream stream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return stream.read();
            }

            public int available() {
                return RequestBodyDecryptWrapper.this.body.length;
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

