/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.field.autoconfigure;

import com.cssw.bootx.encrypt.field.autoconfigure.FieldEncryptProperties;
import com.cssw.bootx.encrypt.field.interceptor.MyBatisDecryptInterceptor;
import com.cssw.bootx.encrypt.field.interceptor.MyBatisEncryptInterceptor;
import com.cssw.bootx.encrypt.field.util.EncryptHelper;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.encrypt.field", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FieldEncryptAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptAutoConfiguration.class);
    private final FieldEncryptProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public MyBatisEncryptInterceptor mybatisEncryptInterceptor() {
        return new MyBatisEncryptInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={MyBatisDecryptInterceptor.class})
    public MyBatisDecryptInterceptor mybatisDecryptInterceptor() {
        return new MyBatisDecryptInterceptor();
    }

    @PostConstruct
    public void postConstruct() {
        EncryptHelper.init(this.properties);
        log.debug("[Bootx Starter] - Auto Configuration 'Encrypt-Field' completed initialization.");
    }

    @Generated
    public FieldEncryptAutoConfiguration(FieldEncryptProperties properties) {
        this.properties = properties;
    }
}

