/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.encrypt.password.encoder.autoconfigure;

import com.cssw.bootx.core.util.validation.CheckUtils;
import com.cssw.bootx.encrypt.password.encoder.autoconfigure.PasswordEncoderProperties;
import com.cssw.bootx.encrypt.password.encoder.enums.PasswordEncoderAlgorithm;
import com.cssw.bootx.encrypt.password.encoder.util.PasswordEncoderUtil;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@AutoConfiguration
@EnableConfigurationProperties(value={PasswordEncoderProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.encrypt.password-encoder", name={"enabled"}, havingValue="true")
public class PasswordEncoderAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordEncoderAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder(PasswordEncoderProperties properties) {
        HashMap<String, PasswordEncoder> encoders = new HashMap<String, PasswordEncoder>();
        encoders.put(PasswordEncoderAlgorithm.BCRYPT.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.BCRYPT));
        encoders.put(PasswordEncoderAlgorithm.SCRYPT.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.SCRYPT));
        encoders.put(PasswordEncoderAlgorithm.PBKDF2.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.PBKDF2));
        encoders.put(PasswordEncoderAlgorithm.ARGON2.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.ARGON2));
        PasswordEncoderAlgorithm algorithm = properties.getAlgorithm();
        CheckUtils.throwIf((PasswordEncoderUtil.getEncoder(algorithm) == null ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5: {}", (Object[])new Object[]{algorithm});
        return new DelegatingPasswordEncoder(algorithm.name().toLowerCase(), encoders);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Encrypt-Password Encoder' completed initialization.");
    }
}

