/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.extension.tenant.handler.datasource;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.cssw.bootx.extension.tenant.TenantDataSourceHandler;
import com.cssw.bootx.extension.tenant.config.TenantDataSource;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTenantDataSourceHandler
implements TenantDataSourceHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTenantDataSourceHandler.class);
    private final DynamicRoutingDataSource dynamicRoutingDataSource;
    private final DefaultDataSourceCreator dataSourceCreator;

    public DefaultTenantDataSourceHandler(DataSource dataSource) {
        this.dynamicRoutingDataSource = (DynamicRoutingDataSource)dataSource;
        this.dataSourceCreator = (DefaultDataSourceCreator)SpringUtil.getBean(DefaultDataSourceCreator.class);
    }

    public void changeDataSource(TenantDataSource tenantDataSource) {
        if (tenantDataSource == null) {
            return;
        }
        String dataSourceName = tenantDataSource.getPoolName();
        if (!this.containsDataSource(dataSourceName)) {
            DataSource datasource = this.createDataSource(tenantDataSource);
            this.dynamicRoutingDataSource.addDataSource(dataSourceName, datasource);
            log.info("Load data source: {}", (Object)dataSourceName);
        }
        DynamicDataSourceContextHolder.push((String)dataSourceName);
        log.info("Change data source: {}", (Object)dataSourceName);
    }

    public boolean containsDataSource(String dataSourceName) {
        return CharSequenceUtil.isNotBlank((CharSequence)dataSourceName) && this.dynamicRoutingDataSource.getDataSources().containsKey(dataSourceName);
    }

    public DataSource createDataSource(TenantDataSource tenantDataSource) {
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        dataSourceProperty.setPoolName(tenantDataSource.getPoolName());
        dataSourceProperty.setDriverClassName(tenantDataSource.getDriverClassName());
        dataSourceProperty.setUrl(tenantDataSource.getUrl());
        dataSourceProperty.setUsername(tenantDataSource.getUsername());
        dataSourceProperty.setPassword(tenantDataSource.getPassword());
        return this.dataSourceCreator.createDataSource(dataSourceProperty);
    }

    public void removeDataSource(String dataSourceName) {
        this.dynamicRoutingDataSource.removeDataSource(dataSourceName);
    }

    public void poll() {
        DynamicDataSourceContextHolder.poll();
    }
}

