/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.idempotent.autoconfigure;

import com.cssw.bootx.cache.redisson.autoconfigure.RedissonAutoConfiguration;
import com.cssw.bootx.idempotent.aop.IdempotentAspect;
import com.cssw.bootx.idempotent.autoconfigure.IdempotentProperties;
import com.cssw.bootx.idempotent.generator.DefaultIdempotentNameGenerator;
import com.cssw.bootx.idempotent.generator.IdempotentNameGenerator;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RedissonAutoConfiguration.class})
@EnableConfigurationProperties(value={IdempotentProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.idempotent", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class IdempotentAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdempotentAutoConfiguration.class);

    @Bean
    public IdempotentAspect idempotentAspect(IdempotentProperties properties, IdempotentNameGenerator idempotentNameGenerator) {
        return new IdempotentAspect(properties, idempotentNameGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public IdempotentNameGenerator idempotentNameGenerator() {
        return new DefaultIdempotentNameGenerator();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Idempotent' completed initialization.");
    }
}

