/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.license.autoconfigure;

import com.cssw.bootx.license.autoconfigure.LicenseVerifyProperties;
import com.cssw.bootx.license.bean.LicenseInstallerBean;
import com.cssw.bootx.license.initializing.LicenseStarterInitializingBean;
import com.cssw.bootx.license.manager.CustomLicenseManager;
import de.schlichtherle.license.LicenseManager;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@AutoConfiguration
@EnableConfigurationProperties(value={LicenseVerifyProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.license.verifier", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LicenseVerifyAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseVerifyAutoConfiguration.class);

    @Bean
    public LicenseInstallerBean licenseInstallerBean(LicenseVerifyProperties properties) {
        return new LicenseInstallerBean(properties);
    }

    @Bean
    @DependsOn(value={"licenseInstallerBean"})
    public LicenseStarterInitializingBean licenseStarterInitializingBean(LicenseInstallerBean licenseInstallerBean) {
        return new LicenseStarterInitializingBean(licenseInstallerBean);
    }

    @Bean
    public LicenseManager licenseManager(LicenseVerifyProperties properties) {
        return CustomLicenseManager.getInstance(properties);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'License-Verifier' completed initialization.");
    }
}

