/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.license.bean;

import com.cssw.bootx.license.autoconfigure.LicenseVerifyProperties;
import com.cssw.bootx.license.exception.LicenseException;
import com.cssw.bootx.license.manager.CustomLicenseManager;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import java.io.File;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInstallerBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseInstallerBean.class);
    private final LicenseVerifyProperties properties;
    private LicenseManager licenseManager;

    public void installLicense() {
        try {
            this.licenseManager = CustomLicenseManager.getInstance(this.properties);
            this.licenseManager.uninstall();
            File licenseFile = Paths.get(this.properties.getStorePath(), "clientLicense", "license.lic").toFile();
            LicenseContent licenseContent = this.licenseManager.install(licenseFile);
            log.info("\u8bc1\u4e66\u8ba4\u8bc1\u901a\u8fc7\uff0c\u5b89\u88c5\u6210\u529f: {}", (Object)licenseContent.getSubject());
        }
        catch (Exception e) {
            throw new LicenseException("\u8bc1\u4e66\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }

    public void uninstallLicense() {
        if (this.licenseManager != null) {
            try {
                this.licenseManager.uninstall();
                log.info("\u8bc1\u4e66\u5df2\u5378\u8f7d");
            }
            catch (Exception e) {
                log.warn("\u5378\u8f7d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void verify() {
        if (this.licenseManager != null) {
            try {
                this.licenseManager.verify();
                log.info("\u8bc1\u4e66\u9a8c\u8bc1\u6210\u529f");
            }
            catch (Exception e) {
                throw new LicenseException("\u8bc1\u4e66\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            }
        } else {
            throw new LicenseException("\u8bc1\u4e66\u8ba4\u8bc1\u5931\u8d25: licenseManager is null");
        }
    }

    @Generated
    public LicenseInstallerBean(LicenseVerifyProperties properties) {
        this.properties = properties;
    }
}

