/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.license.manager;

import com.cssw.bootx.license.autoconfigure.LicenseVerifyProperties;
import com.cssw.bootx.license.bean.LicenseInstallerBean;
import com.cssw.bootx.license.exception.LicenseException;
import com.cssw.bootx.license.model.ConfigParam;
import com.cssw.bootx.license.model.CustomKeyStoreParam;
import com.cssw.bootx.license.model.LicenseExtraModel;
import com.cssw.bootx.license.util.ServerInfoUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import lombok.Generated;
import net.lingala.zip4j.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLicenseManager
extends LicenseManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomLicenseManager.class);
    private static volatile CustomLicenseManager INSTANCE;
    private LicenseExtraModel extraModel;
    private final LicenseVerifyProperties properties;

    private CustomLicenseManager(LicenseVerifyProperties properties) {
        this.properties = properties;
        this.initServerExtraModel();
        this.extractZip();
        ConfigParam configParam = this.getConfigParam();
        Preferences preferences = Preferences.userNodeForPackage(LicenseInstallerBean.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(configParam.getStorePass());
        CustomKeyStoreParam publicKeyStoreParam = new CustomKeyStoreParam(LicenseInstallerBean.class, properties.getStorePath() + File.separator + "clientLicense/publicCerts.keystore", configParam.getPublicAlias(), configParam.getStorePass(), null);
        DefaultLicenseParam licenseParam = new DefaultLicenseParam(configParam.getSubject(), preferences, (KeyStoreParam)publicKeyStoreParam, (CipherParam)cipherParam);
        super.setLicenseParam((LicenseParam)licenseParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomLicenseManager getInstance(LicenseVerifyProperties properties) {
        if (INSTANCE != null) return INSTANCE;
        Class<CustomLicenseManager> clazz = CustomLicenseManager.class;
        synchronized (CustomLicenseManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CustomLicenseManager(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void initServerExtraModel() {
        this.extraModel = ServerInfoUtils.getServerInfos();
    }

    private void extractZip() {
        Path zipPath = Paths.get(this.properties.getStorePath(), "clientLicense.zip");
        Path outputDir = Paths.get(this.properties.getStorePath(), "clientLicense");
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            if (!Files.exists(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            zipFile.extractAll(outputDir.toAbsolutePath().toString());
        }
        catch (IOException e) {
            log.error("\u89e3\u538b clientLicense.zip \u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            throw new LicenseException("\u89e3\u538b\u5931\u8d25", (Throwable)e);
        }
    }

    private ConfigParam getConfigParam() {
        ConfigParam configParam;
        block9: {
            Path configPath = Paths.get(this.properties.getStorePath(), "clientLicense", "clientConfig.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                log.warn("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)configPath);
                return null;
            }
            InputStream inputStream = Files.newInputStream(configPath, new OpenOption[0]);
            try {
                ObjectMapper mapper = new ObjectMapper();
                configParam = (ConfigParam)mapper.readValue(inputStream, ConfigParam.class);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return configParam;
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        super.validate(content);
        Object o = content.getExtra();
        if (this.extraModel != null && o instanceof LicenseExtraModel) {
            LicenseExtraModel contentExtraModel = (LicenseExtraModel)o;
            if (!contentExtraModel.getCpuSerial().equals(this.extraModel.getCpuSerial())) {
                throw new LicenseException("CPU\u6838\u6570\u4e0d\u5339\u914d");
            }
            if (!contentExtraModel.getMainBoardSerial().equals(this.extraModel.getMainBoardSerial())) {
                throw new LicenseException("\u4e3b\u677f\u5e8f\u5217\u53f7\u4e0d\u5339\u914d");
            }
            if (!contentExtraModel.getIpAddress().equals(this.extraModel.getIpAddress())) {
                throw new LicenseException("IP\u5730\u5740\u4e0d\u5339\u914d");
            }
            if (!contentExtraModel.getMacAddress().equals(this.extraModel.getMacAddress())) {
                throw new LicenseException("MAC\u5730\u5740\u4e0d\u5339\u914d");
            }
        } else {
            throw new LicenseException("\u8bc1\u4e66\u65e0\u6548");
        }
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getCertificate();
        if (certificate != null) {
            return (LicenseContent)certificate.getContent();
        }
        byte[] licenseKey = this.getLicenseKey();
        if (licenseKey == null) {
            String subject = this.getLicenseParam().getSubject();
            throw new NoLicenseInstalledException(subject);
        }
        certificate = this.getPrivacyGuard().key2cert(licenseKey);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }
}

