/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.aspect;

import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.log.dao.LogDao;
import com.cssw.bootx.log.handler.LogHandler;
import com.cssw.bootx.log.model.LogProperties;
import com.cssw.bootx.log.model.LogRecord;
import java.lang.reflect.Method;
import java.time.Instant;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final LogProperties logProperties;
    private final LogHandler logHandler;
    private final LogDao logDao;

    @Pointcut(value="@annotation(com.cssw.bootx.log.annotation.Log)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> targetClass;
        Instant startTime = Instant.now();
        Method targetMethod = this.getMethod((JoinPoint)joinPoint);
        if (!this.isRecord(targetMethod, targetClass = joinPoint.getTarget().getClass())) {
            return joinPoint.proceed();
        }
        String errorMsg = null;
        LogRecord.Started startedLogRecord = this.logHandler.start(startTime);
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            errorMsg = CharSequenceUtil.sub((CharSequence)e.getMessage(), (int)0, (int)2000);
            throw e;
        }
        finally {
            try {
                Instant endTime = Instant.now();
                LogRecord logRecord = this.logHandler.finish(startedLogRecord, endTime, this.logProperties.getIncludes(), targetMethod, targetClass);
                if (errorMsg != null) {
                    logRecord.setErrorMsg(errorMsg);
                }
                this.logDao.add(logRecord);
            }
            catch (Exception e) {
                log.error("Logging http log occurred an error: {}.", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
    }

    private boolean isRecord(Method targetMethod, Class<?> targetClass) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null || attributes.getResponse() == null) {
            return false;
        }
        if (this.logProperties.isMatch(attributes.getRequest().getRequestURI())) {
            return false;
        }
        return this.logHandler.isRecord(targetMethod, targetClass);
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return signature.getMethod();
    }

    @Generated
    public LogAspect(LogProperties logProperties, LogHandler logHandler, LogDao logDao) {
        this.logProperties = logProperties;
        this.logHandler = logHandler;
        this.logDao = logDao;
    }
}

