/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.autoconfigure;

import com.cssw.bootx.log.annotation.EnableLog;
import com.cssw.bootx.log.aspect.AccessLogAspect;
import com.cssw.bootx.log.aspect.LogAspect;
import com.cssw.bootx.log.dao.LogDao;
import com.cssw.bootx.log.dao.impl.DefaultLogDaoImpl;
import com.cssw.bootx.log.filter.LogFilter;
import com.cssw.bootx.log.handler.AopLogHandler;
import com.cssw.bootx.log.handler.LogHandler;
import com.cssw.bootx.log.model.LogProperties;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableLog
@EnableConfigurationProperties(value={LogProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class LogAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAutoConfiguration.class);
    private final LogProperties logProperties;
    private final LogHandler logHandler;

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean<LogFilter> logFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new LogFilter(this.logProperties));
        registrationBean.setOrder(2147483547);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogAspect logAspect(LogDao logDao) {
        return new LogAspect(this.logProperties, this.logHandler, logDao);
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessLogAspect accessLogAspect() {
        return new AccessLogAspect(this.logProperties, this.logHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public LogHandler logHandler() {
        return new AopLogHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public LogDao logDao() {
        return new DefaultLogDaoImpl();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Log-AOP' completed initialization.");
    }

    @Generated
    public LogAutoConfiguration(LogProperties logProperties, LogHandler logHandler) {
        this.logProperties = logProperties;
        this.logHandler = logHandler;
    }
}

