/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.messaging.websocket.autoconfigure;

import com.cssw.bootx.messaging.websocket.autoconfigure.WebSocketProperties;
import com.cssw.bootx.messaging.websocket.core.WebSocketClientService;
import com.cssw.bootx.messaging.websocket.core.WebSocketInterceptor;
import com.cssw.bootx.messaging.websocket.dao.WebSocketSessionDao;
import com.cssw.bootx.messaging.websocket.dao.WebSocketSessionDaoDefaultImpl;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.server.HandshakeInterceptor;

@AutoConfiguration
@EnableWebSocket
@EnableConfigurationProperties(value={WebSocketProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.messaging.websocket", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WebSocketAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketAutoConfiguration.class);

    @Bean
    public WebSocketConfigurer webSocketConfigurer(WebSocketProperties properties, WebSocketHandler handler, HandshakeInterceptor interceptor) {
        return registry -> registry.addHandler(handler, new String[]{properties.getPath()}).addInterceptors(new HandshakeInterceptor[]{interceptor}).setAllowedOrigins((String[])properties.getAllowedOrigins().toArray(String[]::new));
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketHandler webSocketHandler(WebSocketProperties properties, WebSocketSessionDao webSocketSessionDao) {
        return new com.cssw.bootx.messaging.websocket.core.WebSocketHandler(properties, webSocketSessionDao);
    }

    @Bean
    @ConditionalOnMissingBean
    public HandshakeInterceptor handshakeInterceptor(WebSocketProperties properties, WebSocketClientService webSocketClientService) {
        return new WebSocketInterceptor(properties, webSocketClientService);
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketSessionDao webSocketSessionDao() {
        return new WebSocketSessionDaoDefaultImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketClientService webSocketClientService() {
        throw new NoSuchBeanDefinitionException(WebSocketClientService.class);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Messaging-WebSocket' completed initialization.");
    }
}

