/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.security.xss.filter;

import cn.hutool.core.collection.CollUtil;
import com.cssw.bootx.core.util.SpringWebUtils;
import com.cssw.bootx.security.xss.autoconfigure.XssProperties;
import com.cssw.bootx.security.xss.filter.XssServletRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssFilter.class);
    private final XssProperties xssProperties;

    public void init(FilterConfig filterConfig) {
        log.debug("[Bootx Starter] - Auto Configuration 'Web-XssFilter' completed initialization.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (this.xssProperties.isEnabled()) {
                List<String> excludePatterns = this.xssProperties.getExcludePatterns();
                if (CollUtil.isNotEmpty(excludePatterns) && SpringWebUtils.isMatch((String)request.getServletPath(), excludePatterns)) {
                    filterChain.doFilter((ServletRequest)request, servletResponse);
                    return;
                }
                List<String> includePatterns = this.xssProperties.getIncludePatterns();
                if (CollUtil.isNotEmpty(includePatterns)) {
                    if (SpringWebUtils.isMatch((String)request.getServletPath(), includePatterns)) {
                        filterChain.doFilter((ServletRequest)new XssServletRequestWrapper(request, this.xssProperties), servletResponse);
                    } else {
                        filterChain.doFilter((ServletRequest)request, servletResponse);
                    }
                    return;
                }
                filterChain.doFilter((ServletRequest)new XssServletRequestWrapper(request, this.xssProperties), servletResponse);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Generated
    public XssFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

