/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.core;

import cn.hutool.core.util.StrUtil;
import com.cssw.bootx.storage.autoconfigure.properties.StorageProperties;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.core.UploadPretreatment;
import com.cssw.bootx.storage.domain.file.EnhancedMultipartFile;
import com.cssw.bootx.storage.domain.file.FileWrapper;
import com.cssw.bootx.storage.domain.file.ProgressAwareMultipartFile;
import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.domain.model.req.ThumbnailInfo;
import com.cssw.bootx.storage.domain.model.resp.FileInfo;
import com.cssw.bootx.storage.domain.model.resp.FilePartInfo;
import com.cssw.bootx.storage.domain.model.resp.MultipartInitResp;
import com.cssw.bootx.storage.domain.model.resp.MultipartUploadResp;
import com.cssw.bootx.storage.domain.model.resp.StrategyStatusResp;
import com.cssw.bootx.storage.engine.StorageStrategyRouter;
import com.cssw.bootx.storage.processor.preprocess.FileNameGenerator;
import com.cssw.bootx.storage.processor.preprocess.FilePathGenerator;
import com.cssw.bootx.storage.processor.preprocess.FileValidator;
import com.cssw.bootx.storage.processor.preprocess.ThumbnailProcessor;
import com.cssw.bootx.storage.processor.preprocess.UploadCompleteProcessor;
import com.cssw.bootx.storage.processor.progress.UploadProgressListener;
import com.cssw.bootx.storage.processor.registry.ProcessorRegistry;
import com.cssw.bootx.storage.service.FileProcessor;
import com.cssw.bootx.storage.service.FileRecorder;
import com.cssw.bootx.storage.strategy.StorageStrategy;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStorageService.class);
    private final StorageStrategyRouter router;
    private final StorageProperties storageProperties;
    private final ProcessorRegistry processorRegistry;
    private final FileRecorder fileRecorder;
    private final ThreadLocal<List<FileProcessor>> tempProcessors = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<UploadProgressListener> progressListener = new ThreadLocal();

    public String getDefaultPlatform() {
        return this.router.getDefaultStorage();
    }

    public ProcessorRegistry getProcessorRegistry() {
        return this.processorRegistry;
    }

    public UploadPretreatment of(MultipartFile file) {
        return this.createPretreatment(file, null);
    }

    public UploadPretreatment of(MultipartFile file, String platform) {
        return this.createPretreatment(file, platform);
    }

    public UploadPretreatment of(byte[] bytes, String filename, String contentType) {
        return this.createPretreatment(bytes, filename, contentType);
    }

    public UploadPretreatment of(InputStream inputStream, String filename, String contentType) {
        return this.createPretreatment(inputStream, filename, contentType);
    }

    public UploadPretreatment of(Object obj, String filename, String contentType) {
        return this.createPretreatment(obj, filename, contentType);
    }

    public UploadPretreatment of(Object obj) {
        return this.createPretreatment(obj, null, null);
    }

    private UploadPretreatment createPretreatment(MultipartFile file, String platform) {
        UploadPretreatment pretreatment = new UploadPretreatment(this, file);
        return platform != null ? pretreatment.platform(platform) : pretreatment;
    }

    private UploadPretreatment createPretreatment(Object source, String filename, String contentType) {
        FileWrapper wrapper = filename != null || contentType != null ? FileWrapper.of(source, filename, contentType) : FileWrapper.of(source);
        return this.createPretreatment(wrapper.toMultipartFile(), null);
    }

    public void addProcessor(FileProcessor processor) {
        this.tempProcessors.get().add(processor);
    }

    public void onProgress(UploadProgressListener listener) {
        this.progressListener.set(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo upload(UploadContext context) {
        String platform = context.getPlatform();
        try {
            List<FileProcessor> customProcessors = this.tempProcessors.get();
            UploadProgressListener listener = this.progressListener.get();
            if (listener != null) {
                context.setProgressListener(listener);
            }
            this.prepareFile(context, listener);
            this.setFileReadPhase(context.getFile(), ProgressAwareMultipartFile.ReadPhase.VALIDATION);
            this.executeValidation(context, platform, customProcessors);
            this.generateFileNameIfEmpty(context, platform, customProcessors);
            this.generateFilePathIfEmpty(context, platform, customProcessors);
            if (StrUtil.isBlank((CharSequence)context.getBucket())) {
                context.setBucket(this.getDefaultBucket(platform));
            }
            ThumbnailProcessor thumbnailProcessor = this.prepareThumbnail(context, platform, customProcessors);
            this.setFileReadPhase(context.getFile(), ProgressAwareMultipartFile.ReadPhase.UPLOAD);
            this.upload(platform, context.getBucket(), context.getFullPath(), context.getFile());
            FileInfo fileInfo = this.buildFileInfo(platform, context);
            if (thumbnailProcessor != null && context.isGenerateThumbnail()) {
                this.setFileReadPhase(context.getFile(), ProgressAwareMultipartFile.ReadPhase.THUMBNAIL);
                this.processThumbnail(fileInfo, thumbnailProcessor, context);
            }
            if (this.fileRecorder != null) {
                this.fileRecorder.save(fileInfo);
            }
            this.triggerCompleteEvent(fileInfo, context, platform, customProcessors);
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        finally {
            this.cleanup(context);
        }
    }

    private void prepareFile(UploadContext context, UploadProgressListener listener) {
        MultipartFile file = context.getFile();
        if (file instanceof ProgressAwareMultipartFile) {
            return;
        }
        boolean needCache = true;
        if (listener != null) {
            context.setFile(new ProgressAwareMultipartFile(file, needCache, listener));
        } else if (!(file instanceof EnhancedMultipartFile)) {
            context.setFile(EnhancedMultipartFile.wrap(file, needCache));
        }
    }

    private void setFileReadPhase(MultipartFile file, ProgressAwareMultipartFile.ReadPhase phase) {
        if (file instanceof ProgressAwareMultipartFile) {
            ((ProgressAwareMultipartFile)file).setReadPhase(phase);
        }
    }

    private void executeValidation(UploadContext context, String platform, List<FileProcessor> customProcessors) {
        List<FileValidator> validators = this.collectProcessors(customProcessors, FileValidator.class, platform, context);
        for (FileValidator validator : validators) {
            if (!validator.support(context)) continue;
            validator.validate(context);
        }
    }

    private void generateFileNameIfEmpty(UploadContext context, String platform, List<FileProcessor> customProcessors) {
        if (StrUtil.isNotBlank((CharSequence)context.getFormatFileName())) {
            return;
        }
        FileNameGenerator nameGenerator = this.findFirstProcessor(customProcessors, FileNameGenerator.class, platform, context);
        if (nameGenerator != null && nameGenerator.support(context)) {
            context.setFormatFileName(nameGenerator.generate(context));
        }
    }

    private void generateFilePathIfEmpty(UploadContext context, String platform, List<FileProcessor> customProcessors) {
        if (StrUtil.isNotBlank((CharSequence)context.getPath())) {
            return;
        }
        FilePathGenerator pathGenerator = this.findFirstProcessor(customProcessors, FilePathGenerator.class, platform, context);
        if (pathGenerator != null && pathGenerator.support(context)) {
            context.setPath(pathGenerator.path(context));
        }
    }

    private ThumbnailProcessor prepareThumbnail(UploadContext context, String platform, List<FileProcessor> customProcessors) {
        ThumbnailProcessor thumbnailProcessor = this.findFirstProcessor(customProcessors, ThumbnailProcessor.class, platform, context);
        boolean needThumbnail = thumbnailProcessor != null && thumbnailProcessor.support(context);
        context.setGenerateThumbnail(needThumbnail);
        return thumbnailProcessor;
    }

    private FileInfo buildFileInfo(String platform, UploadContext context) {
        FileInfo fileInfo = this.getFileInfo(platform, context.getBucket(), context.getFullPath());
        fileInfo.setOriginalFileName(context.getFile().getOriginalFilename());
        if (context.getMetadata() != null && !context.getMetadata().isEmpty()) {
            fileInfo.getMetadata().putAll(context.getMetadata());
        }
        return fileInfo;
    }

    private void triggerCompleteEvent(FileInfo fileInfo, UploadContext context, String platform, List<FileProcessor> customProcessors) {
        List<UploadCompleteProcessor> completeProcessors = this.collectProcessors(customProcessors, UploadCompleteProcessor.class, platform, context);
        for (UploadCompleteProcessor processor : completeProcessors) {
            if (!processor.support(context)) continue;
            processor.onComplete(fileInfo);
        }
    }

    private <T extends FileProcessor> List<T> collectProcessors(List<FileProcessor> customProcessors, Class<T> processorClass, String platform, UploadContext context) {
        ArrayList<T> processors = new ArrayList<T>();
        if (customProcessors != null) {
            customProcessors.stream().filter(processorClass::isInstance).map(processorClass::cast).forEach(processors::add);
        }
        processors.addAll(this.processorRegistry.getProcessors(processorClass, platform, context));
        return processors;
    }

    private <T extends FileProcessor> T findFirstProcessor(List<FileProcessor> customProcessors, Class<T> processorClass, String platform, UploadContext context) {
        if (customProcessors != null) {
            Optional<FileProcessor> customProcessor = customProcessors.stream().filter(processorClass::isInstance).map(processorClass::cast).findFirst();
            if (customProcessor.isPresent()) {
                return (T)customProcessor.get();
            }
        }
        return this.processorRegistry.getProcessor(processorClass, platform, context);
    }

    private void processThumbnail(FileInfo fileInfo, ThumbnailProcessor processor, UploadContext context) {
        try {
            MultipartFile file = context.getFile();
            try (InputStream is = file.getInputStream();){
                ThumbnailInfo thumbnailInfo = processor.process(context, is);
                String filePrefix = StrUtil.subBefore((CharSequence)fileInfo.getPath(), (CharSequence)".", (boolean)true);
                String thumbnailPath = filePrefix + ".thumb." + thumbnailInfo.getFormat();
                String thumbnailFileName = StrUtil.subAfter((CharSequence)thumbnailPath, (CharSequence)"/", (boolean)true);
                EnhancedMultipartFile thumbnailFile = new EnhancedMultipartFile(thumbnailFileName, thumbnailFileName, "image/" + thumbnailInfo.getFormat(), thumbnailInfo.getData());
                this.upload(context.getPlatform(), context.getBucket(), thumbnailPath, thumbnailFile);
                fileInfo.setThumbnailPath(thumbnailPath);
                fileInfo.setThumbnailSize(Long.valueOf(thumbnailInfo.getData().length));
            }
        }
        catch (Exception e) {
            log.warn("\u7f29\u7565\u56fe\u5904\u7406\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void cleanup(UploadContext context) {
        this.tempProcessors.remove();
        this.progressListener.remove();
        this.cleanupFileCache(context.getFile());
    }

    private void cleanupFileCache(MultipartFile file) {
        if (file instanceof ProgressAwareMultipartFile) {
            ((ProgressAwareMultipartFile)file).clearCache();
        } else if (file instanceof EnhancedMultipartFile) {
            ((EnhancedMultipartFile)file).clearCache();
        }
    }

    public MultipartInitResp initMultipartUpload(String bucket, String platform, String path, String contentType, Map<String, String> metadata) {
        bucket = bucket == null ? this.getDefaultBucket(platform) : bucket;
        MultipartInitResp result = this.router.route(platform).initMultipartUpload(bucket, path, contentType, metadata);
        if (this.fileRecorder != null) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileId(result.getFileId());
            fileInfo.setPlatform(platform);
            fileInfo.setBucket(bucket);
            fileInfo.setPath(path);
            fileInfo.setContentType(contentType);
            fileInfo.setMetadata(metadata != null ? new HashMap<String, String>(metadata) : new HashMap());
            fileInfo.getMetadata().put("uploadId", result.getUploadId());
            fileInfo.getMetadata().put("status", "UPLOADING");
            this.fileRecorder.save(fileInfo);
        }
        return result;
    }

    public MultipartUploadResp uploadPart(String platform, String bucket, String path, String uploadId, int partNumber, InputStream data) {
        MultipartUploadResp result = this.router.route(platform).uploadPart(bucket, path, uploadId, partNumber, data);
        if (this.fileRecorder != null && result.isSuccess()) {
            FilePartInfo partInfo = new FilePartInfo();
            partInfo.setUploadId(uploadId);
            partInfo.setBucket(bucket);
            partInfo.setPath(path);
            partInfo.setPartNumber(partNumber);
            partInfo.setPartETag(result.getPartETag());
            partInfo.setPartSize(result.getPartSize());
            partInfo.setStatus("SUCCESS");
            partInfo.setUploadTime(LocalDateTime.now());
            this.fileRecorder.saveFilePart(partInfo);
        }
        return result;
    }

    public FileInfo completeMultipartUpload(String platform, String bucket, String path, String uploadId, List<MultipartUploadResp> clientParts) {
        List<Object> recordedParts = this.fileRecorder != null ? this.fileRecorder.getFileParts(uploadId) : new ArrayList();
        List<MultipartUploadResp> parts = recordedParts.stream().map(partInfo -> {
            MultipartUploadResp resp = new MultipartUploadResp();
            resp.setPartNumber(partInfo.getPartNumber());
            resp.setPartETag(partInfo.getPartETag());
            resp.setPartSize(partInfo.getPartSize());
            resp.setSuccess("SUCCESS".equals(partInfo.getStatus()));
            return resp;
        }).collect(Collectors.toList());
        if (parts.isEmpty() && clientParts != null) {
            parts = clientParts;
        }
        this.validatePartsCompleteness(parts);
        boolean needVerify = true;
        FileInfo fileInfo = this.router.route(platform).completeMultipartUpload(bucket, path, uploadId, parts, needVerify);
        if (this.fileRecorder != null) {
            fileInfo.getMetadata().put("uploadId", uploadId);
            fileInfo.getMetadata().put("status", "COMPLETED");
            this.fileRecorder.update(fileInfo);
            this.fileRecorder.deleteFileParts(uploadId);
        }
        return fileInfo;
    }

    public void abortMultipartUpload(String platform, String bucket, String path, String uploadId) {
        this.router.route(platform).abortMultipartUpload(bucket, path, uploadId);
        if (this.fileRecorder != null) {
            this.fileRecorder.deleteFileParts(uploadId);
        }
    }

    private void validatePartsCompleteness(List<MultipartUploadResp> parts) {
        if (parts.isEmpty()) {
            throw new StorageException("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u5206\u7247\u4fe1\u606f");
        }
        List<Integer> partNumbers = parts.stream().map(MultipartUploadResp::getPartNumber).sorted().toList();
        for (int i = 0; i < partNumbers.size(); ++i) {
            if (partNumbers.get(i) == i + 1) continue;
            throw new StorageException("\u5206\u7247\u7f16\u53f7\u4e0d\u8fde\u7eed\uff0c\u7f3a\u5931\u5206\u7247: " + (i + 1));
        }
        List<Integer> failedParts = parts.stream().filter(part -> !part.isSuccess()).map(MultipartUploadResp::getPartNumber).toList();
        if (!failedParts.isEmpty()) {
            throw new StorageException("\u5b58\u5728\u5931\u8d25\u7684\u5206\u7247: " + failedParts);
        }
    }

    public List<MultipartUploadResp> listParts(String platform, String bucket, String path, String uploadId) {
        return this.router.route(platform).listParts(bucket, path, uploadId);
    }

    public String getDefaultBucket(String platform) {
        return this.router.route(platform).defaultBucket();
    }

    public void upload(String platform, String bucket, String path, MultipartFile file) {
        this.router.route(platform).upload(bucket, path, file);
    }

    public InputStream download(String platform, String bucket, String path) {
        return this.router.route(platform).download(bucket, path);
    }

    public InputStream download(String bucket, String path) {
        return this.download(this.storageProperties.getDefaultPlatform(), bucket, path);
    }

    public InputStream batchDownload(String platform, String bucket, List<String> paths) {
        return this.router.route(platform).batchDownload(bucket, paths);
    }

    public void delete(String platform, String bucket, String path) {
        this.router.route(platform).delete(bucket, path);
    }

    public void delete(FileInfo info) {
        this.router.route(info.getPlatform()).delete(info.getBucket(), info.getFullPath());
    }

    public void batchDelete(String platform, String bucket, List<String> paths) {
        this.router.route(platform).batchDelete(bucket, paths);
    }

    public boolean exists(String platform, String bucket, String path) {
        return this.router.route(platform).exists(bucket, path);
    }

    public FileInfo getFileInfo(String platform, String bucket, String path) {
        return this.router.route(platform).getFileInfo(bucket, path);
    }

    public List<FileInfo> list(String platform, String bucket, String prefix, int maxKeys) {
        return this.router.route(platform).list(bucket, prefix, maxKeys);
    }

    public void copy(String platform, String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        this.router.route(platform).copy(sourceBucket, targetBucket, sourcePath, targetPath);
    }

    public void move(String platform, String sourceBucket, String targetBucket, String sourcePath, String targetPath) {
        this.router.route(platform).move(sourceBucket, targetBucket, sourcePath, targetPath);
    }

    public String generatePresignedUrl(String platform, String bucket, String path, long expireSeconds) {
        return this.router.route(platform).generatePresignedUrl(bucket, path, expireSeconds);
    }

    public <T extends StorageStrategy> void register(T strategy) {
        this.router.registerDynamic(strategy);
    }

    public void defaultStorage(String platform) {
        this.router.registerDynamicDefaultStorage(platform);
    }

    public boolean unload(String platform) {
        if (!this.router.isDynamic(platform)) {
            throw new StorageException("\u53ea\u80fd\u5378\u8f7d\u52a8\u6001\u6ce8\u518c\u7684\u7b56\u7565: " + platform);
        }
        return this.router.unloadDynamic(platform);
    }

    public Set<String> getAvailablePlatform() {
        return this.router.getAllPlatform();
    }

    public boolean exists(String platform) {
        return this.router.getAllPlatform().contains(platform);
    }

    public boolean isDynamic(String platform) {
        return this.router.isDynamic(platform);
    }

    public boolean isFromConfig(String platform) {
        return this.router.isFromConfig(platform);
    }

    public Map<String, StrategyStatusResp> getStrategyStatus() {
        return this.router.getFullStrategyStatus();
    }

    public Map<String, String> getActiveStrategyInfo() {
        return this.router.getActiveStrategyInfo();
    }

    @Generated
    public FileStorageService(StorageStrategyRouter router, StorageProperties storageProperties, ProcessorRegistry processorRegistry, FileRecorder fileRecorder) {
        this.router = router;
        this.storageProperties = storageProperties;
        this.processorRegistry = processorRegistry;
        this.fileRecorder = fileRecorder;
    }
}

