/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.domain.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.springframework.web.multipart.MultipartFile;

public class EnhancedMultipartFile
implements MultipartFile {
    private final MultipartFile originalFile;
    private final String name;
    private final String originalFilename;
    private final String contentType;
    private byte[] cachedBytes;
    private final boolean cacheEnabled;
    private final boolean isWrapped;

    public EnhancedMultipartFile(MultipartFile originalFile, boolean enableCache) {
        this.originalFile = originalFile;
        this.name = originalFile.getName();
        this.originalFilename = originalFile.getOriginalFilename();
        this.contentType = originalFile.getContentType();
        this.cacheEnabled = enableCache;
        this.isWrapped = true;
        this.cachedBytes = null;
    }

    public EnhancedMultipartFile(String name, String originalFilename, String contentType, byte[] content) {
        this.originalFile = null;
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.cachedBytes = content;
        this.cacheEnabled = false;
        this.isWrapped = false;
    }

    public static EnhancedMultipartFile wrap(MultipartFile file, boolean enableCache) {
        if (file instanceof EnhancedMultipartFile) {
            return (EnhancedMultipartFile)file;
        }
        return new EnhancedMultipartFile(file, enableCache);
    }

    public static EnhancedMultipartFile wrap(MultipartFile file) {
        return EnhancedMultipartFile.wrap(file, false);
    }

    public static EnhancedMultipartFile create(String name, String originalFilename, String contentType, byte[] content) {
        return new EnhancedMultipartFile(name, originalFilename, contentType, content);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        if (this.isWrapped) {
            return this.originalFile.isEmpty();
        }
        return this.cachedBytes == null || this.cachedBytes.length == 0;
    }

    public long getSize() {
        if (this.cachedBytes != null) {
            return this.cachedBytes.length;
        }
        if (this.isWrapped) {
            return this.originalFile.getSize();
        }
        return 0L;
    }

    public byte[] getBytes() throws IOException {
        if (this.cacheEnabled) {
            return this.getBytesWithCache();
        }
        return this.getBytesWithoutCache();
    }

    public InputStream getInputStream() throws IOException {
        if (this.cachedBytes != null) {
            return new ByteArrayInputStream(this.cachedBytes);
        }
        if (this.cacheEnabled && this.isWrapped) {
            this.loadToCache();
            return new ByteArrayInputStream(this.cachedBytes);
        }
        if (this.isWrapped) {
            return this.originalFile.getInputStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (this.cachedBytes != null) {
            Files.write(dest.toPath(), this.cachedBytes, new OpenOption[0]);
        } else if (this.isWrapped) {
            this.originalFile.transferTo(dest);
        } else {
            dest.createNewFile();
        }
    }

    public void clearCache() {
        if (this.cacheEnabled && this.isWrapped) {
            this.cachedBytes = null;
        }
    }

    public boolean isCached() {
        return this.cachedBytes != null;
    }

    public byte[] getCachedBytes() {
        return this.cachedBytes;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    private byte[] getBytesWithCache() throws IOException {
        if (this.cachedBytes == null && this.isWrapped) {
            this.loadToCache();
        }
        return this.cachedBytes;
    }

    private byte[] getBytesWithoutCache() throws IOException {
        if (this.isWrapped) {
            return this.originalFile.getBytes();
        }
        return this.cachedBytes;
    }

    private void loadToCache() throws IOException {
        if (this.isWrapped && this.originalFile != null) {
            this.cachedBytes = this.originalFile.getBytes();
        }
    }
}

